% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia.R
\name{as.function.exactmvp}
\alias{as.function.exactmvp}
\title{Exact multivariate polynomial as function}
\usage{
\method{as.function}{exactmvp}(x, ...)
}
\arguments{
\item{x}{object of class \code{exactmvp}; the functions returned by
\code{\link{Jack_julia}} can return such objects}

\item{...}{ignored}
}
\value{
A function having the same variables as the polynomial.
}
\description{
Coerces an exact multivariate polynomial into a function.
}
\examples{
# library(jack)
\donttest{if(JuliaConnectoR::juliaSetupOk()){
  julia <- Jack_julia()
  ( pol <- julia$JackPol(m = 2, lambda = c(3, 1), alpha = "3/2") )
  f <- as.function(pol)
  f(2, "3/7")
  # the evaluation is performed by (R)yacas and complex numbers are
  # allowed; the imaginary unit is denoted by `I`
  f("2 + 2*I", "1/4")
  JuliaConnectoR::stopJulia()
}}
}
