% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JackPol.R
\name{JackPolR}
\alias{JackPolR}
\title{Jack polynomial}
\usage{
JackPolR(n, lambda, alpha, algorithm = "DK", basis = "canonical", which = "J")
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{alpha}{parameter of the Jack polynomial, a number, possibly (and
preferably) a \code{\link[gmp]{bigq}} rational number}

\item{algorithm}{the algorithm used, either \code{"DK"} or \code{"naive"}}

\item{basis}{the polynomial basis for \code{algorithm = "naive"},
either \code{"canonical"} or \code{"MSF"} (monomial symmetric functions);
for \code{algorithm = "DK"} the canonical basis is always used and
this parameter is ignored}

\item{which}{which Jack polynomial, \code{"J"}, \code{"P"} or \code{"Q"};
this argument is taken into account \strong{only} if \code{alpha} is a
\code{bigq} number and \code{algorithm = "DK"}}
}
\value{
A \code{mvp} multivariate polynomial (see \link[mvp]{mvp-package}),
 or a \code{qspray} multivariate polynomial if \code{alpha}
 is a \code{bigq} rational number and \code{algorithm = "DK"}, or a
 character string if \code{basis = "MSF"}.
}
\description{
Returns the Jack polynomial.
}
\examples{
JackPolR(3, lambda = c(3,1), alpha = gmp::as.bigq(2,3),
                  algorithm = "naive")
JackPolR(3, lambda = c(3,1), alpha = 2/3, algorithm = "DK")
JackPolR(3, lambda = c(3,1), alpha = gmp::as.bigq(2,3), algorithm = "DK")
JackPolR(3, lambda = c(3,1), alpha= gmp::as.bigq(2,3),
        algorithm = "naive", basis = "MSF")
# when the Jack polynomial is a `qspray` object, you can
# evaluate it with `qspray::evalQspray`:
jack <- JackPolR(3, lambda = c(3, 1), alpha = gmp::as.bigq(2))
evalQspray(jack, c("1", "1/2", "3"))
}
