# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Merge a reference genome into a single sequence.
#'
#'
#' @param ref_genome_ptr An external pointer (R class \code{externalptr}) to a
#'     \code{RefGenome} class in C++ (the full class in C++ is
#'     \code{Rcpp::XPtr<RefGenome>}).
#'
#' @return Nothing. Changes are made in place.
#'
#' @name merge_sequences
#'
#' @noRd
#'
merge_sequences_cpp <- function(ref_genome_ptr) {
    invisible(.Call(`_jackalope_merge_sequences_cpp`, ref_genome_ptr))
}

#' Filter reference genome sequences by size or for a proportion of total nucleotides.
#'
#'
#' @inheritParams ref_genome_ptr merge_sequences
#' @param min_seq_size Integer minimum sequence size to keep.
#'     Defaults to \code{0}, which results in this argument being ignored.
#' @param out_seq_prop Numeric proportion of total sequence to keep.
#'     Defaults to \code{0}, which results in this argument being ignored.
#'
#' @return Nothing. Changes are made in place.
#'
#' @name filter_sequences
#'
#' @noRd
#'
#'
filter_sequences_cpp <- function(ref_genome_ptr, min_seq_size = 0L, out_seq_prop = 0) {
    invisible(.Call(`_jackalope_filter_sequences_cpp`, ref_genome_ptr, min_seq_size, out_seq_prop))
}

#' Replace Ns with randome nucleotides.
#'
#'
#' @return Nothing. Changes are made in place.
#'
#' @name replace_Ns_cpp
#'
#' @noRd
#'
#'
replace_Ns_cpp <- function(ref_genome_ptr, pi_tcag, n_threads, show_progress) {
    invisible(.Call(`_jackalope_replace_Ns_cpp`, ref_genome_ptr, pi_tcag, n_threads, show_progress))
}

#' Create `RefGenome` pointer based on nucleotide equilibrium frequencies.
#'
#' Function to create random sequences for a new reference genome object.
#'
#' Note that this function will never return empty sequences.
#'
#' @param n_seqs Number of sequences.
#' @param len_mean Mean for the gamma distribution for sequence sizes.
#' @param len_sd Standard deviation for the gamma distribution for sequence sizes.
#'     If set to `<= 0`, all sequences will be the same length.
#' @param pi_tcag Vector of nucleotide equilibrium frequencies for
#'     "T", "C", "A", and "G", respectively.
#' @param n_threads Number of threads to use via OpenMP.
#'
#'
#' @return External pointer to a `RefGenome` C++ object.
#'
#' @noRd
#'
#' @examples
#'
#'
create_genome_cpp <- function(n_seqs, len_mean, len_sd, pi_tcag, n_threads) {
    .Call(`_jackalope_create_genome_cpp`, n_seqs, len_mean, len_sd, pi_tcag, n_threads)
}

#' Create random sequences as a character vector.
#'
#' This function is used internally for testing.
#'
#'
#' @inheritParams create_genome
#'
#' @return Character vector of sequence strings.
#'
#'
#' @noRd
#'
rando_seqs <- function(n_seqs, len_mean, len_sd = 0, pi_tcag = numeric(0), n_threads = 1L) {
    .Call(`_jackalope_rando_seqs`, n_seqs, len_mean, len_sd, pi_tcag, n_threads)
}

#' Illumina sequence for reference object.
#'
#'
#' @noRd
#'
illumina_ref_cpp <- function(ref_genome_ptr, paired, matepair, out_prefix, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes) {
    invisible(.Call(`_jackalope_illumina_ref_cpp`, ref_genome_ptr, paired, matepair, out_prefix, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes))
}

#' Illumina sequence for reference object.
#'
#'
#' @noRd
#'
illumina_var_cpp <- function(var_set_ptr, paired, matepair, out_prefix, sep_files, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, variant_probs, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes) {
    invisible(.Call(`_jackalope_illumina_var_cpp`, var_set_ptr, paired, matepair, out_prefix, sep_files, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, variant_probs, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes))
}

#' PacBio sequence for reference object.
#'
#'
#' @noRd
#'
pacbio_ref_cpp <- function(ref_genome_ptr, out_prefix, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst) {
    invisible(.Call(`_jackalope_pacbio_ref_cpp`, ref_genome_ptr, out_prefix, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst))
}

#' PacBio sequence for reference object.
#'
#'
#' @noRd
#'
pacbio_var_cpp <- function(var_set_ptr, out_prefix, sep_files, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, variant_probs, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst) {
    invisible(.Call(`_jackalope_pacbio_var_cpp`, var_set_ptr, out_prefix, sep_files, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, variant_probs, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst))
}

#' Write Gamma matrix info to a tab-delimited BED file.
#'
#'
#'
#' @noRd
#'
write_bed <- function(out_prefix, gamma_mats, seq_names, compress, comp_method) {
    invisible(.Call(`_jackalope_write_bed`, out_prefix, gamma_mats, seq_names, compress, comp_method))
}

#' Read a non-indexed fasta file to a \code{RefGenome} object.
#'
#' @param file_names File names of the fasta file(s).
#' @param cut_names Boolean for whether to cut sequence names at the first space.
#'     Defaults to \code{TRUE}.
#' @param remove_soft_mask Boolean for whether to remove soft-masking by making
#'    sequences all uppercase. Defaults to \code{TRUE}.
#'
#' @return Nothing.
#'
#' @noRd
#'
read_fasta_noind <- function(fasta_files, cut_names, remove_soft_mask) {
    .Call(`_jackalope_read_fasta_noind`, fasta_files, cut_names, remove_soft_mask)
}

#' Read an indexed fasta file to a \code{RefGenome} object.
#'
#' @param file_name File name of the fasta file.
#' @param remove_soft_mask Boolean for whether to remove soft-masking by making
#'    sequences all uppercase. Defaults to \code{TRUE}.
#' @param offsets Vector of sequence offsets from the fasta index file.
#' @param names Vector of sequence names from the fasta index file.
#' @param lengths Vector of sequence lengths from the fasta index file.
#' @param line_lens Vector of sequence line lengths from the fasta index file.
#'
#' @return Nothing.
#'
#' @noRd
#'
#'
read_fasta_ind <- function(fasta_files, fai_files, remove_soft_mask) {
    .Call(`_jackalope_read_fasta_ind`, fasta_files, fai_files, remove_soft_mask)
}

#' Write \code{RefGenome} to an uncompressed fasta file.
#'
#' @param out_prefix Prefix to file name of output fasta file.
#' @param ref_genome_ptr An external pointer to a \code{RefGenome} C++ object.
#' @param text_width The number of characters per line in the output fasta file.
#' @param compress Boolean for whether to compress output.
#'
#' @return Nothing.
#'
#' @noRd
#'
#'
write_ref_fasta <- function(out_prefix, ref_genome_ptr, text_width, compress, comp_method, show_progress) {
    invisible(.Call(`_jackalope_write_ref_fasta`, out_prefix, ref_genome_ptr, text_width, compress, comp_method, show_progress))
}

#' Write \code{VarSet} to an uncompressed fasta file.
#'
#' @param out_prefix Prefix to file name of output fasta file.
#' @param var_set_ptr An external pointer to a \code{VarSet} C++ object.
#' @param text_width The number of characters per line in the output fasta file.
#' @param compress Boolean for whether to compress output.
#'
#' @return Nothing.
#'
#' @noRd
#'
#'
write_vars_fasta <- function(out_prefix, var_set_ptr, text_width, compress, comp_method, n_threads, show_progress) {
    invisible(.Call(`_jackalope_write_vars_fasta`, out_prefix, var_set_ptr, text_width, compress, comp_method, n_threads, show_progress))
}

#' Read a ms output file with newick gene trees and return the gene tree strings.
#'
#' @param ms_file File name of the ms output file.
#'
#' @return A vector of strings for each set of gene trees.
#'
#' @noRd
#'
read_ms_trees_ <- function(ms_file) {
    .Call(`_jackalope_read_ms_trees_`, ms_file)
}

#' Read a ms output file with segregating sites and return the matrices of site info.
#'
#' @param ms_file File name of the ms output file.
#'
#' @return A vector of strings for each set of gene trees.
#'
#' @noRd
#'
coal_file_sites <- function(ms_file) {
    .Call(`_jackalope_coal_file_sites`, ms_file)
}

#' Read VCF from a vcfR object.
#'
#'
#' @noRd
#'
read_vcfr <- function(reference_ptr, var_names, haps_list, seq_inds, pos, ref_seq) {
    .Call(`_jackalope_read_vcfr`, reference_ptr, var_names, haps_list, seq_inds, pos, ref_seq)
}

#' Write `variants` to VCF file.
#'
#'
#' @noRd
#'
write_vcf_cpp <- function(out_prefix, compress, var_set_ptr, sample_matrix, show_progress) {
    invisible(.Call(`_jackalope_write_vcf_cpp`, out_prefix, compress, var_set_ptr, sample_matrix, show_progress))
}

make_mutation_sampler_base <- function(Q, pi_tcag, insertion_rates, deletion_rates, region_size) {
    .Call(`_jackalope_make_mutation_sampler_base`, Q, pi_tcag, insertion_rates, deletion_rates, region_size)
}

#' Create XPtr to nested vector of PhyloTree objects from phylogeny information.
#'
#' @noRd
#'
phylo_info_to_trees <- function(genome_phylo_info) {
    .Call(`_jackalope_phylo_info_to_trees`, genome_phylo_info)
}

#' Evolve all sequences in a reference genome.
#'
#' @noRd
#'
evolve_seqs <- function(ref_genome_ptr, sampler_base_ptr, phylo_info_ptr, gamma_mats, n_threads, show_progress) {
    .Call(`_jackalope_evolve_seqs`, ref_genome_ptr, sampler_base_ptr, phylo_info_ptr, gamma_mats, n_threads, show_progress)
}

#' Add mutations manually from R.
#'
#' This section applies to the next 3 functions.
#'
#' Note that all indices are in 0-based C++ indexing. This means that the first
#' item is indexed by `0`, and so forth.
#'
#' @param var_set_ptr External pointer to a C++ `VarSet` object
#' @param var_ind Integer index to the desired variant. Uses 0-based indexing!
#' @param seq_ind Integer index to the desired sequence. Uses 0-based indexing!
#' @param new_pos_ Integer index to the desired subsitution location.
#'     Uses 0-based indexing!
#'
#' @noRd
NULL

#' Function to print info on a `RefGenome`.
#'
#' Access `RefGenome` class's print method from R.
#'
#' @noRd
#'
print_ref_genome <- function(ref_genome_ptr) {
    invisible(.Call(`_jackalope_print_ref_genome`, ref_genome_ptr))
}

#' Function to print info on a VarSet.
#'
#' Access `VarSet` class's print method from R.
#'
#' @noRd
#'
print_var_set <- function(var_set_ptr) {
    invisible(.Call(`_jackalope_print_var_set`, var_set_ptr))
}

#' Make a RefGenome object from a set of sequences.
#'
#' Used for testing.
#'
#' @noRd
#'
make_ref_genome <- function(seqs) {
    .Call(`_jackalope_make_ref_genome`, seqs)
}

#' Make a VarSet object from a RefGenome pointer and # variants.
#'
#' Used for testing.
#'
#'
#' @noRd
#'
make_var_set <- function(ref_genome_ptr, n_vars) {
    .Call(`_jackalope_make_var_set`, ref_genome_ptr, n_vars)
}

view_ref_genome_nseqs <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome_nseqs`, ref_genome_ptr)
}

view_var_set_nseqs <- function(var_set_ptr) {
    .Call(`_jackalope_view_var_set_nseqs`, var_set_ptr)
}

view_var_set_nvars <- function(var_set_ptr) {
    .Call(`_jackalope_view_var_set_nvars`, var_set_ptr)
}

view_ref_genome_seq_sizes <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome_seq_sizes`, ref_genome_ptr)
}

#' See all sequence sizes in a VarGenome object within a VarSet.
#'
#' @noRd
#'
view_var_genome_seq_sizes <- function(var_set_ptr, var_ind) {
    .Call(`_jackalope_view_var_genome_seq_sizes`, var_set_ptr, var_ind)
}

view_ref_genome_seq <- function(ref_genome_ptr, seq_ind) {
    .Call(`_jackalope_view_ref_genome_seq`, ref_genome_ptr, seq_ind)
}

#' Function to piece together the strings for one sequence in a VarGenome.
#'
#' @noRd
#'
view_var_genome_seq <- function(var_set_ptr, var_ind, seq_ind) {
    .Call(`_jackalope_view_var_genome_seq`, var_set_ptr, var_ind, seq_ind)
}

view_ref_genome <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome`, ref_genome_ptr)
}

#' Function to piece together the strings for all sequences in a VarGenome.
#'
#' @noRd
#'
view_var_genome <- function(var_set_ptr, var_ind) {
    .Call(`_jackalope_view_var_genome`, var_set_ptr, var_ind)
}

view_ref_genome_seq_names <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome_seq_names`, ref_genome_ptr)
}

#' See all variant-genome names in a VarSet object.
#'
#' @noRd
#'
view_var_set_var_names <- function(var_set_ptr) {
    .Call(`_jackalope_view_var_set_var_names`, var_set_ptr)
}

#' See GC content in a RefGenome object.
#'
#' @noRd
#'
view_ref_genome_gc_content <- function(ref_genome_ptr, seq_ind, start, end) {
    .Call(`_jackalope_view_ref_genome_gc_content`, ref_genome_ptr, seq_ind, start, end)
}

#' See GC content in a VarSet object.
#'
#' @noRd
#'
view_var_set_gc_content <- function(var_set_ptr, seq_ind, var_ind, start, end) {
    .Call(`_jackalope_view_var_set_gc_content`, var_set_ptr, seq_ind, var_ind, start, end)
}

#' See any nucleotide's content in a RefGenome object.
#'
#' @noRd
#'
view_ref_genome_nt_content <- function(ref_genome_ptr, nt, seq_ind, start, end) {
    .Call(`_jackalope_view_ref_genome_nt_content`, ref_genome_ptr, nt, seq_ind, start, end)
}

#' See any nucleotide's content in a VarSet object.
#'
#' @noRd
#'
view_var_set_nt_content <- function(var_set_ptr, nt, seq_ind, var_ind, start, end) {
    .Call(`_jackalope_view_var_set_nt_content`, var_set_ptr, nt, seq_ind, var_ind, start, end)
}

set_ref_genome_seq_names <- function(ref_genome_ptr, seq_inds, names) {
    invisible(.Call(`_jackalope_set_ref_genome_seq_names`, ref_genome_ptr, seq_inds, names))
}

clean_ref_genome_seq_names <- function(ref_genome_ptr) {
    invisible(.Call(`_jackalope_clean_ref_genome_seq_names`, ref_genome_ptr))
}

set_var_set_var_names <- function(var_set_ptr, var_inds, names) {
    invisible(.Call(`_jackalope_set_var_set_var_names`, var_set_ptr, var_inds, names))
}

remove_ref_genome_seqs <- function(ref_genome_ptr, seq_inds) {
    invisible(.Call(`_jackalope_remove_ref_genome_seqs`, ref_genome_ptr, seq_inds))
}

remove_var_set_vars <- function(var_set_ptr, var_inds) {
    invisible(.Call(`_jackalope_remove_var_set_vars`, var_set_ptr, var_inds))
}

add_ref_genome_seqs <- function(ref_genome_ptr, new_seqs, new_names) {
    invisible(.Call(`_jackalope_add_ref_genome_seqs`, ref_genome_ptr, new_seqs, new_names))
}

add_var_set_vars <- function(var_set_ptr, new_names) {
    invisible(.Call(`_jackalope_add_var_set_vars`, var_set_ptr, new_names))
}

dup_var_set_vars <- function(var_set_ptr, var_inds, new_names) {
    invisible(.Call(`_jackalope_dup_var_set_vars`, var_set_ptr, var_inds, new_names))
}

#' Turns a VarGenome's mutations into a list of data frames.
#'
#' Internal function for testing.
#'
#'
#' @noRd
#'
view_mutations <- function(var_set_ptr, var_ind) {
    .Call(`_jackalope_view_mutations`, var_set_ptr, var_ind)
}

#' Turns a VarGenome's mutations into a list of data frames.
#'
#' Internal function for testing.
#'
#'
#' @noRd
#'
examine_mutations <- function(var_set_ptr, var_ind, seq_ind) {
    .Call(`_jackalope_examine_mutations`, var_set_ptr, var_ind, seq_ind)
}

#' Faster version of table function to count the number of mutations in Gamma regions.
#'
#' @param gamma_ends Vector of endpoints for gamma regions
#' @param positions Vector of positions that you want to bin into gamma regions.
#'
#' @noRd
#'
table_gammas <- function(gamma_ends, positions) {
    .Call(`_jackalope_table_gammas`, gamma_ends, positions)
}

#' @describeIn add_mutations Add a substitution.
#'
#' @inheritParams add_mutations
#' @param nucleo_ Character to substitute for existing one.
#'
#' @noRd
#'
add_substitution <- function(var_set_ptr, var_ind, seq_ind, nucleo_, new_pos_) {
    invisible(.Call(`_jackalope_add_substitution`, var_set_ptr, var_ind, seq_ind, nucleo_, new_pos_))
}

#' @describeIn add_mutations Add an insertion.
#'
#' @inheritParams add_mutations
#' @param nucleos_ Nucleotides to insert at the desired location.
#'
#'
#' @noRd
#'
add_insertion <- function(var_set_ptr, var_ind, seq_ind, nucleos_, new_pos_) {
    invisible(.Call(`_jackalope_add_insertion`, var_set_ptr, var_ind, seq_ind, nucleos_, new_pos_))
}

#' @describeIn add_mutations Add a deletion.
#'
#' @inheritParams add_mutations
#' @param size_ Size of deletion.
#'
#'
#' @noRd
#'
add_deletion <- function(var_set_ptr, var_ind, seq_ind, size_, new_pos_) {
    invisible(.Call(`_jackalope_add_deletion`, var_set_ptr, var_ind, seq_ind, size_, new_pos_))
}

#' Get a rate for given start and end points of a VarSequence.
#'
#' @noRd
#'
test_rate <- function(start, end, var_ind, seq_ind, var_set_ptr, sampler_base_ptr, gamma_mat_) {
    .Call(`_jackalope_test_rate`, start, end, var_ind, seq_ind, var_set_ptr, sampler_base_ptr, gamma_mat_)
}

#' Fill matrix of Gamma-region end points and Gamma values.
#'
#' @param gamma_mat The gamma matrix to fill.
#' @param gammas_x_sizes The value of `sum(gamma[i] * region_size[i])` to fill in.
#'     This value is used to later determine (in fxn `make_gamma_mats`) the
#'     mean gamma value across the whole genome, which is then used to make sure that
#'     the overall mean is 1.
#' @param seq_size_ Length of the focal sequence.
#' @param region_size_ Size of each Gamma region.
#' @param shape The shape parameter for the Gamma distribution from which
#'     Gamma values will be derived.
#' @param invariant Proportion of invariant regions.
#' @param eng A random number generator.
#'
#'
#' @noRd
#'
NULL

#' Make matrices of Gamma-region end points and Gamma values for multiple sequences.
#'
#' @param seq_sizes Lengths of the sequences in the genome.
#' @param region_size_ Size of each Gamma region.
#' @param shape The shape parameter for the Gamma distribution from which
#'     Gamma values will be derived.
#'
#'
#' @noRd
#'
make_gamma_mats <- function(seq_sizes, region_size_, shape, invariant) {
    .Call(`_jackalope_make_gamma_mats`, seq_sizes, region_size_, shape, invariant)
}

#' Check input Gamma matrices for proper # columns and end points.
#'
#' @param mats List of matrices to check.
#' @param seq_sizes Vector of sequences sizes for all sequences.
#'
#' @return A length-2 vector of potential error codes and the index (1-based indexing)
#'     to which matrix was a problem.
#'
#' @noRd
#'
check_gamma_mats <- function(mats, seq_sizes) {
    invisible(.Call(`_jackalope_check_gamma_mats`, mats, seq_sizes))
}

#' Construct necessary information for substitution models.
#'
#' For a more detailed explanation, see `vignette("sub-models")`.
#'
#'
#' @name sub_models
#'
#' @seealso \code{\link{create_variants}}
#'
#' @return A `sub_model_info` object, which is just a wrapper around a list with
#' fields `Q` and `pi_tcag`. The former has the rate matrix, and the latter
#' has the equilibrium nucleotide densities for "T", "C", "A", and "G", respectively.
#' Access the rate matrix for a `sub_model_info` object named `x` via `x$Q` and
#' densities via `x$pi_tcag`.
#'
#' @examples
#' # Same substitution rate for all types:
#' Q_JC69 <- sub_JC69(lambda = 0.1)
#'
#' # Transitions 2x more likely than transversions:
#' Q_K80 <- sub_K80(alpha = 0.2, beta = 0.1)
#'
#' # Same as above, but incorporating equilibrium frequencies
#' sub_HKY85(pi_tcag = c(0.1, 0.2, 0.3, 0.4),
#'           alpha = 0.2, beta = 0.1)
#'
NULL

#' @describeIn sub_models TN93 model.
#'
#' @param pi_tcag Vector of length 4 indicating the equilibrium distributions of
#'     T, C, A, and G respectively. Values must be >= 0, and
#'     they are forced to sum to 1.
#' @param alpha_1 Substitution rate for T <-> C transition.
#' @param alpha_2 Substitution rate for A <-> G transition.
#' @param beta Substitution rate for transversions.
#'
#' @export
#'
sub_TN93 <- function(pi_tcag, alpha_1, alpha_2, beta) {
    .Call(`_jackalope_sub_TN93`, pi_tcag, alpha_1, alpha_2, beta)
}

#' @describeIn sub_models JC69 model.
#'
#' @param lambda Substitution rate for all possible substitutions.
#'
#' @export
#'
#'
sub_JC69 <- function(lambda) {
    .Call(`_jackalope_sub_JC69`, lambda)
}

#' @describeIn sub_models K80 model.
#'
#' @param alpha Substitution rate for transitions.
#' @inheritParams sub_TN93
#'
#' @export
#'
sub_K80 <- function(alpha, beta) {
    .Call(`_jackalope_sub_K80`, alpha, beta)
}

#' @describeIn sub_models F81 model.
#'
#' @inheritParams sub_TN93
#'
#' @export
#'
sub_F81 <- function(pi_tcag) {
    .Call(`_jackalope_sub_F81`, pi_tcag)
}

#' @describeIn sub_models HKY85 model.
#'
#'
#' @inheritParams sub_TN93
#' @inheritParams sub_K80
#'
#' @export
#'
sub_HKY85 <- function(pi_tcag, alpha, beta) {
    .Call(`_jackalope_sub_HKY85`, pi_tcag, alpha, beta)
}

#' @describeIn sub_models F84 model.
#'
#'
#' @inheritParams sub_TN93
#' @inheritParams sub_K80
#' @param kappa The transition/transversion rate ratio.
#'
#' @export
#'
sub_F84 <- function(pi_tcag, beta, kappa) {
    .Call(`_jackalope_sub_F84`, pi_tcag, beta, kappa)
}

#' @describeIn sub_models GTR model.
#'
#' @inheritParams sub_TN93
#' @param abcdef A vector of length 6 that contains the off-diagonal elements
#'     for the substitution rate matrix.
#'     See `vignette("sub-models")` for how the values are ordered in the matrix.
#'
#' @export
#'
sub_GTR <- function(pi_tcag, abcdef) {
    .Call(`_jackalope_sub_GTR`, pi_tcag, abcdef)
}

#' @describeIn sub_models UNREST model.
#'
#'
#' @param Q Matrix of substitution rates for "T", "C", "A", and "G", respectively.
#'     Item `Q[i,j]` is the rate of substitution from nucleotide `i` to nucleotide `j`.
#'     Do not include indel rates here!
#'     Values on the diagonal are calculated inside the function so are ignored.
#'
#' @export
#'
#'
sub_UNREST <- function(Q) {
    .Call(`_jackalope_sub_UNREST`, Q)
}

using_openmp <- function() {
    .Call(`_jackalope_using_openmp`)
}

#' Used below to directly make a MutationTypeSampler
#'
#' @noRd
#'
NULL

#' Add mutations at segregating sites for one sequence from coalescent simulation output.
#'
#' @noRd
#'
NULL

#' Add mutations at segregating sites from coalescent simulation output.
#'
#' @noRd
#'
add_ssites_cpp <- function(ref_genome_ptr, seg_sites, Q, pi_tcag, insertion_rates, deletion_rates, n_threads, show_progress) {
    .Call(`_jackalope_add_ssites_cpp`, ref_genome_ptr, seg_sites, Q, pi_tcag, insertion_rates, deletion_rates, n_threads, show_progress)
}

