# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

merge_all_chromosomes_cpp <- function(ref_genome_ptr) {
    invisible(.Call(`_jackalope_merge_all_chromosomes_cpp`, ref_genome_ptr))
}

merge_chromosomes_cpp <- function(ref_genome_ptr, chrom_inds) {
    invisible(.Call(`_jackalope_merge_chromosomes_cpp`, ref_genome_ptr, chrom_inds))
}

#' Filter reference genome chromosomes by size or for a proportion of total nucleotides.
#'
#'
#' @inheritParams ref_genome_ptr merge_chromosomes
#' @param min_chrom_size Integer minimum chromosome size to keep.
#'     Defaults to \code{0}, which results in this argument being ignored.
#' @param out_chrom_prop Numeric proportion of total chromosome to keep.
#'     Defaults to \code{0}, which results in this argument being ignored.
#'
#' @return Nothing. Changes are made in place.
#'
#' @name filter_chromosomes
#'
#' @noRd
#'
#'
filter_chromosomes_cpp <- function(ref_genome_ptr, min_chrom_size = 0L, out_chrom_prop = 0) {
    invisible(.Call(`_jackalope_filter_chromosomes_cpp`, ref_genome_ptr, min_chrom_size, out_chrom_prop))
}

#' Replace Ns with randome nucleotides.
#'
#'
#' @return Nothing. Changes are made in place.
#'
#' @name replace_Ns_cpp
#'
#' @noRd
#'
#'
replace_Ns_cpp <- function(ref_genome_ptr, pi_tcag, n_threads, show_progress) {
    invisible(.Call(`_jackalope_replace_Ns_cpp`, ref_genome_ptr, pi_tcag, n_threads, show_progress))
}

#' Create `RefGenome` pointer based on nucleotide equilibrium frequencies.
#'
#' Function to create random chromosomes for a new reference genome object.
#'
#' Note that this function will never return empty chromosomes.
#'
#' @param n_chroms Number of chromosomes.
#' @param len_mean Mean for the gamma distribution for chromosome sizes.
#' @param len_sd Standard deviation for the gamma distribution for chromosome sizes.
#'     If set to `<= 0`, all chromosomes will be the same length.
#' @param pi_tcag Vector of nucleotide equilibrium frequencies for
#'     "T", "C", "A", and "G", respectively.
#' @param n_threads Number of threads to use via OpenMP.
#'
#'
#' @return External pointer to a `RefGenome` C++ object.
#'
#' @noRd
#'
#' @examples
#'
#'
create_genome_cpp <- function(n_chroms, len_mean, len_sd, pi_tcag, n_threads) {
    .Call(`_jackalope_create_genome_cpp`, n_chroms, len_mean, len_sd, pi_tcag, n_threads)
}

#' Create random chromosomes as a character vector.
#'
#' This function is used internally for testing.
#'
#'
#' @inheritParams create_genome
#'
#' @return Character vector of chromosome strings.
#'
#'
#' @noRd
#'
rando_chroms <- function(n_chroms, len_mean, len_sd = 0, pi_tcag = numeric(0), n_threads = 1L) {
    .Call(`_jackalope_rando_chroms`, n_chroms, len_mean, len_sd, pi_tcag, n_threads)
}

add_ssites_cpp <- function(ref_genome_ptr, seg_sites, Q, pi_tcag, insertion_rates, deletion_rates, n_threads, show_progress) {
    .Call(`_jackalope_add_ssites_cpp`, ref_genome_ptr, seg_sites, Q, pi_tcag, insertion_rates, deletion_rates, n_threads, show_progress)
}

#' Illumina chromosome for reference object.
#'
#'
#' @noRd
#'
illumina_ref_cpp <- function(ref_genome_ptr, paired, matepair, out_prefix, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes) {
    invisible(.Call(`_jackalope_illumina_ref_cpp`, ref_genome_ptr, paired, matepair, out_prefix, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes))
}

#' Illumina chromosome for reference object.
#'
#'
#' @noRd
#'
illumina_hap_cpp <- function(hap_set_ptr, paired, matepair, out_prefix, sep_files, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, haplotype_probs, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes) {
    invisible(.Call(`_jackalope_illumina_hap_cpp`, hap_set_ptr, paired, matepair, out_prefix, sep_files, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, haplotype_probs, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes))
}

#' PacBio chromosome for reference object.
#'
#'
#' @noRd
#'
pacbio_ref_cpp <- function(ref_genome_ptr, out_prefix, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst) {
    invisible(.Call(`_jackalope_pacbio_ref_cpp`, ref_genome_ptr, out_prefix, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst))
}

#' PacBio chromosome for reference object.
#'
#'
#' @noRd
#'
pacbio_hap_cpp <- function(hap_set_ptr, out_prefix, sep_files, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, haplotype_probs, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst) {
    invisible(.Call(`_jackalope_pacbio_hap_cpp`, hap_set_ptr, out_prefix, sep_files, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, haplotype_probs, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst))
}

#' Read a non-indexed fasta file to a \code{RefGenome} object.
#'
#' @param file_names File names of the fasta file(s).
#' @param cut_names Boolean for whether to cut chromosome names at the first space.
#'     Defaults to \code{TRUE}.
#' @param remove_soft_mask Boolean for whether to remove soft-masking by making
#'    chromosomes all uppercase. Defaults to \code{TRUE}.
#'
#' @return Nothing.
#'
#' @noRd
#'
read_fasta_noind <- function(fasta_files, cut_names, remove_soft_mask) {
    .Call(`_jackalope_read_fasta_noind`, fasta_files, cut_names, remove_soft_mask)
}

#' Read an indexed fasta file to a \code{RefGenome} object.
#'
#' @param file_name File name of the fasta file.
#' @param remove_soft_mask Boolean for whether to remove soft-masking by making
#'    chromosomes all uppercase. Defaults to \code{TRUE}.
#' @param offsets Vector of chromosome offsets from the fasta index file.
#' @param names Vector of chromosome names from the fasta index file.
#' @param lengths Vector of chromosome lengths from the fasta index file.
#' @param line_lens Vector of chromosome line lengths from the fasta index file.
#'
#' @return Nothing.
#'
#' @noRd
#'
#'
read_fasta_ind <- function(fasta_files, fai_files, remove_soft_mask) {
    .Call(`_jackalope_read_fasta_ind`, fasta_files, fai_files, remove_soft_mask)
}

#' Write \code{RefGenome} to an uncompressed fasta file.
#'
#' @param out_prefix Prefix to file name of output fasta file.
#' @param ref_genome_ptr An external pointer to a \code{RefGenome} C++ object.
#' @param text_width The number of characters per line in the output fasta file.
#' @param compress Boolean for whether to compress output.
#'
#' @return Nothing.
#'
#' @noRd
#'
#'
write_ref_fasta <- function(out_prefix, ref_genome_ptr, text_width, compress, comp_method, show_progress) {
    invisible(.Call(`_jackalope_write_ref_fasta`, out_prefix, ref_genome_ptr, text_width, compress, comp_method, show_progress))
}

#' Write \code{HapSet} to an uncompressed fasta file.
#'
#' @param out_prefix Prefix to file name of output fasta file.
#' @param hap_set_ptr An external pointer to a \code{HapSet} C++ object.
#' @param text_width The number of characters per line in the output fasta file.
#' @param compress Boolean for whether to compress output.
#'
#' @return Nothing.
#'
#' @noRd
#'
#'
write_haps_fasta <- function(out_prefix, hap_set_ptr, text_width, compress, comp_method, n_threads, show_progress) {
    invisible(.Call(`_jackalope_write_haps_fasta`, out_prefix, hap_set_ptr, text_width, compress, comp_method, n_threads, show_progress))
}

#' Read a ms output file with newick gene trees and return the gene tree strings.
#'
#' @param ms_file File name of the ms output file.
#'
#' @return A vector of strings for each set of gene trees.
#'
#' @noRd
#'
read_ms_trees_ <- function(ms_file) {
    .Call(`_jackalope_read_ms_trees_`, ms_file)
}

#' Read a ms output file with segregating sites and return the matrices of site info.
#'
#' @param ms_file File name of the ms output file.
#'
#' @return A vector of strings for each set of gene trees.
#'
#' @noRd
#'
coal_file_sites <- function(ms_file) {
    .Call(`_jackalope_coal_file_sites`, ms_file)
}

read_vcf_cpp <- function(reference_ptr, fn, print_names) {
    .Call(`_jackalope_read_vcf_cpp`, reference_ptr, fn, print_names)
}

#' Write `haplotypes` to VCF file.
#'
#'
#' @noRd
#'
write_vcf_cpp <- function(out_prefix, compress, hap_set_ptr, sample_matrix, show_progress) {
    invisible(.Call(`_jackalope_write_vcf_cpp`, out_prefix, compress, hap_set_ptr, sample_matrix, show_progress))
}

#' Evolve all chromosomes in a reference genome.
#'
#' @noRd
#'
evolve_across_trees <- function(ref_genome_ptr, genome_phylo_info, Q, U, Ui, L, invariant, insertion_rates, deletion_rates, epsilon, pi_tcag, n_threads, show_progress) {
    .Call(`_jackalope_evolve_across_trees`, ref_genome_ptr, genome_phylo_info, Q, U, Ui, L, invariant, insertion_rates, deletion_rates, epsilon, pi_tcag, n_threads, show_progress)
}

#' Add mutations manually from R.
#'
#' This section applies to the next 3 functions.
#'
#' Note that all indices are in 0-based C++ indexing. This means that the first
#' item is indexed by `0`, and so forth.
#'
#' @param hap_set_ptr External pointer to a C++ `HapSet` object
#' @param hap_ind Integer index to the desired haplotype. Uses 0-based indexing!
#' @param chrom_ind Integer index to the desired chromosome. Uses 0-based indexing!
#' @param new_pos_ Integer index to the desired subsitution location.
#'     Uses 0-based indexing!
#'
#' @noRd
NULL

#' Function to print info on a `RefGenome`.
#'
#' Access `RefGenome` class's print method from R.
#'
#' @noRd
#'
print_ref_genome <- function(ref_genome_ptr) {
    invisible(.Call(`_jackalope_print_ref_genome`, ref_genome_ptr))
}

#' Function to print info on a HapSet.
#'
#' Access `HapSet` class's print method from R.
#'
#' @noRd
#'
print_hap_set <- function(hap_set_ptr) {
    invisible(.Call(`_jackalope_print_hap_set`, hap_set_ptr))
}

#' Make a RefGenome object from a set of chromosomes.
#'
#' Used for testing.
#'
#' @noRd
#'
make_ref_genome <- function(chroms) {
    .Call(`_jackalope_make_ref_genome`, chroms)
}

#' Make a HapSet object from a RefGenome pointer and # haplotypes.
#'
#' Used for testing.
#'
#'
#' @noRd
#'
make_hap_set <- function(ref_genome_ptr, n_haps) {
    .Call(`_jackalope_make_hap_set`, ref_genome_ptr, n_haps)
}

view_ref_genome_nchroms <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome_nchroms`, ref_genome_ptr)
}

view_hap_set_nchroms <- function(hap_set_ptr) {
    .Call(`_jackalope_view_hap_set_nchroms`, hap_set_ptr)
}

view_hap_set_nhaps <- function(hap_set_ptr) {
    .Call(`_jackalope_view_hap_set_nhaps`, hap_set_ptr)
}

view_ref_genome_chrom_sizes <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome_chrom_sizes`, ref_genome_ptr)
}

#' See all chromosome sizes in a HapGenome object within a HapSet.
#'
#' @noRd
#'
view_hap_genome_chrom_sizes <- function(hap_set_ptr, hap_ind) {
    .Call(`_jackalope_view_hap_genome_chrom_sizes`, hap_set_ptr, hap_ind)
}

view_ref_genome_chrom <- function(ref_genome_ptr, chrom_ind) {
    .Call(`_jackalope_view_ref_genome_chrom`, ref_genome_ptr, chrom_ind)
}

#' Function to piece together the strings for one chromosome in a HapGenome.
#'
#' @noRd
#'
view_hap_genome_chrom <- function(hap_set_ptr, hap_ind, chrom_ind) {
    .Call(`_jackalope_view_hap_genome_chrom`, hap_set_ptr, hap_ind, chrom_ind)
}

view_ref_genome <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome`, ref_genome_ptr)
}

#' Function to piece together the strings for all chromosomes in a HapGenome.
#'
#' @noRd
#'
view_hap_genome <- function(hap_set_ptr, hap_ind) {
    .Call(`_jackalope_view_hap_genome`, hap_set_ptr, hap_ind)
}

view_ref_genome_chrom_names <- function(ref_genome_ptr) {
    .Call(`_jackalope_view_ref_genome_chrom_names`, ref_genome_ptr)
}

#' See all haplotype-genome names in a HapSet object.
#'
#' @noRd
#'
view_hap_set_hap_names <- function(hap_set_ptr) {
    .Call(`_jackalope_view_hap_set_hap_names`, hap_set_ptr)
}

#' See GC content in a RefGenome object.
#'
#' @noRd
#'
view_ref_genome_gc_content <- function(ref_genome_ptr, chrom_ind, start, end) {
    .Call(`_jackalope_view_ref_genome_gc_content`, ref_genome_ptr, chrom_ind, start, end)
}

#' See GC content in a HapSet object.
#'
#' @noRd
#'
view_hap_set_gc_content <- function(hap_set_ptr, chrom_ind, hap_ind, start, end) {
    .Call(`_jackalope_view_hap_set_gc_content`, hap_set_ptr, chrom_ind, hap_ind, start, end)
}

#' See any nucleotide's content in a RefGenome object.
#'
#' @noRd
#'
view_ref_genome_nt_content <- function(ref_genome_ptr, nt, chrom_ind, start, end) {
    .Call(`_jackalope_view_ref_genome_nt_content`, ref_genome_ptr, nt, chrom_ind, start, end)
}

#' See any nucleotide's content in a HapSet object.
#'
#' @noRd
#'
view_hap_set_nt_content <- function(hap_set_ptr, nt, chrom_ind, hap_ind, start, end) {
    .Call(`_jackalope_view_hap_set_nt_content`, hap_set_ptr, nt, chrom_ind, hap_ind, start, end)
}

set_ref_genome_chrom_names <- function(ref_genome_ptr, chrom_inds, names) {
    invisible(.Call(`_jackalope_set_ref_genome_chrom_names`, ref_genome_ptr, chrom_inds, names))
}

clean_ref_genome_chrom_names <- function(ref_genome_ptr) {
    invisible(.Call(`_jackalope_clean_ref_genome_chrom_names`, ref_genome_ptr))
}

set_hap_set_hap_names <- function(hap_set_ptr, hap_inds, names) {
    invisible(.Call(`_jackalope_set_hap_set_hap_names`, hap_set_ptr, hap_inds, names))
}

remove_ref_genome_chroms <- function(ref_genome_ptr, chrom_inds) {
    invisible(.Call(`_jackalope_remove_ref_genome_chroms`, ref_genome_ptr, chrom_inds))
}

remove_hap_set_haps <- function(hap_set_ptr, hap_inds) {
    invisible(.Call(`_jackalope_remove_hap_set_haps`, hap_set_ptr, hap_inds))
}

add_ref_genome_chroms <- function(ref_genome_ptr, new_chroms, new_names) {
    invisible(.Call(`_jackalope_add_ref_genome_chroms`, ref_genome_ptr, new_chroms, new_names))
}

add_hap_set_haps <- function(hap_set_ptr, new_names) {
    invisible(.Call(`_jackalope_add_hap_set_haps`, hap_set_ptr, new_names))
}

dup_hap_set_haps <- function(hap_set_ptr, hap_inds, new_names) {
    invisible(.Call(`_jackalope_dup_hap_set_haps`, hap_set_ptr, hap_inds, new_names))
}

#' Turns a HapGenome's mutations into a list of data frames.
#'
#' Internal function for testing.
#'
#'
#' @noRd
#'
view_mutations <- function(hap_set_ptr, hap_ind) {
    .Call(`_jackalope_view_mutations`, hap_set_ptr, hap_ind)
}

#' Turns a HapGenome's mutations into a list of data frames.
#'
#' Internal function for testing.
#'
#'
#' @noRd
#'
examine_mutations <- function(hap_set_ptr, hap_ind, chrom_ind) {
    .Call(`_jackalope_examine_mutations`, hap_set_ptr, hap_ind, chrom_ind)
}

#' @describeIn add_mutations Add a substitution.
#'
#' @inheritParams add_mutations
#' @param nucleo_ Character to substitute for existing one.
#'
#' @noRd
#'
add_substitution <- function(hap_set_ptr, hap_ind, chrom_ind, nucleo_, new_pos_) {
    invisible(.Call(`_jackalope_add_substitution`, hap_set_ptr, hap_ind, chrom_ind, nucleo_, new_pos_))
}

#' @describeIn add_mutations Add an insertion.
#'
#' @inheritParams add_mutations
#' @param nucleos_ Nucleotides to insert at the desired location.
#'
#'
#' @noRd
#'
add_insertion <- function(hap_set_ptr, hap_ind, chrom_ind, nucleos_, new_pos_) {
    invisible(.Call(`_jackalope_add_insertion`, hap_set_ptr, hap_ind, chrom_ind, nucleos_, new_pos_))
}

#' @describeIn add_mutations Add a deletion.
#'
#' @inheritParams add_mutations
#' @param size_ Size of deletion.
#'
#'
#' @noRd
#'
add_deletion <- function(hap_set_ptr, hap_ind, chrom_ind, size_, new_pos_) {
    invisible(.Call(`_jackalope_add_deletion`, hap_set_ptr, hap_ind, chrom_ind, size_, new_pos_))
}

sub_TN93_cpp <- function(mu, pi_tcag, alpha_1, alpha_2, beta, gamma_shape, gamma_k, invariant) {
    .Call(`_jackalope_sub_TN93_cpp`, mu, pi_tcag, alpha_1, alpha_2, beta, gamma_shape, gamma_k, invariant)
}

sub_GTR_cpp <- function(mu, pi_tcag, abcdef, gamma_shape, gamma_k, invariant) {
    .Call(`_jackalope_sub_GTR_cpp`, mu, pi_tcag, abcdef, gamma_shape, gamma_k, invariant)
}

sub_UNREST_cpp <- function(mu, Q, gamma_shape, gamma_k, invariant) {
    .Call(`_jackalope_sub_UNREST_cpp`, mu, Q, gamma_shape, gamma_k, invariant)
}

using_openmp <- function() {
    .Call(`_jackalope_using_openmp`)
}

