isComplex <- function(z){
  (is.complex(z) || is.numeric(z)) && length(z) == 1L && !is.na(z)
}

isComplexPair <- function(x){
  (is.complex(x) || is.numeric(x)) && length(x) == 2L && !anyNA(x)
}

check_and_get_tau <- function(tau, q){
  if(is.null(tau) && is.null(q)){
    stop("You must supply either `tau` or `q`.")
  }
  if(!is.null(tau) && !is.null(q)){
    stop("You must supply either `tau` or `q`, not both.")
  }
  if(!is.null(tau)){
    stopifnot(isComplex(tau))
    if(Im(tau) <= 0){
      stop("The imaginary part of `tau` must be strictly positive.")
    }
  }
  if(!is.null(q)){
    stopifnot(isComplex(q))
    if(Mod(q) >= 1){
      stop("The modulus of `q` must be strictly less than one.")
    }
    if(Im(q) == 0 && Re(q) <= 0){
      stop("If `q` is real, it must be strictly positive.")
    }
    tau <- -1i * log(q) / pi
    # if(Im(tau) <= 0){
    #   stop("Invalid value of `q`.")
    # }
  }
  tau
}

#' @importFrom Carlson elliptic_F
#' @noRd
tau_from_m <- function(m){
  1i * elliptic_F(pi/2, 1-m) / elliptic_F(pi/2, m) 
}

check_and_get_tau_from_m <- function(tau, m){
  if(is.null(tau) && is.null(m)){
    stop("You must supply either `tau` or `m`.")
  }
  if(!is.null(tau) && !is.null(m)){
    stop("You must supply either `tau` or `m`, not both.")
  }
  if(!is.null(tau)){
    stopifnot(isComplex(tau))
    if(Im(tau) <= 0){
      stop("The imaginary part of `tau` must be strictly positive.")
    }
  }
  if(!is.null(m)){
    stopifnot(isComplex(m))
    tau <- tau_from_m(m)
    if(Im(tau) <= 0){
      stop("Invalid value of `m`.")
    }
  }
  tau
}
