% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{comparedens}
\alias{comparedens}
\title{Compare Density}
\usage{
comparedens(x1, x2, p = NULL, minCI = 0.99, ...)
}
\arguments{
\item{x1}{Output object returned from \code{jagsUI}; or alternately a \code{data.frame}}

\item{x2}{Second output object returned from \code{jagsUI}; or alternately a \code{data.frame}}

\item{p}{Optional vector of parameters to subset.  All parameters with names matching the beginning of the
string supplied will be returned.  If the default (\code{NULL}) is accepted, all parameters will be plotted.}

\item{minCI}{Minimum CI width for plotting.  This is intended as a method for excluding far-outlying MCMC
samples when determining the appropriate y-axis limits for plotting.  Defaults to 99\%.}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Side-by-side kernel density plots for all parameters (or a specified subset) from two \code{jagsUI}
output objects or \code{data.frame}s.  The intent of this function is easy comparison of inferences from two comparable models.

Kernel densities are plotted vertically, either left- or right-facing.  Parameters with the same name are
plotted facing one another.
}
\examples{
## This is the same output object twice, but shows functionality.
comparedens(x1=asdf_jags_out, x2=asdf_jags_out, p=c("a","b","sig"))
}
\seealso{
\link{comparecat}
}
\author{
Matt Tyers
}
