% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_jags_example_data.R
\name{tar_jags_example_data}
\alias{tar_jags_example_data}
\title{Simulate example JAGS data.}
\format{
A list with the following elements:
\itemize{
\item \code{n}: integer, number of data points.
\item \code{x}: numeric, covariate vector.
\item \code{y}: numeric, response variable.
\item \code{true_beta}: numeric of length 1, value of the regression
coefficient \code{beta} used in simulation.
\item \code{.join_data}: a list of simulated values to be appended
to as a \code{.join_data} column in the output of
targets generated by functions such as
\code{\link[=tar_jags_rep_summary]{tar_jags_rep_summary()}}. Contains the
regression coefficient \code{beta} (numeric of length 1)
and prior predictive data \code{y} (numeric vector).
}
}
\usage{
tar_jags_example_data(n = 10L)
}
\arguments{
\item{n}{Integer of length 1, number of data points.}
}
\value{
List, dataset compatible with the model file from
\code{\link[=tar_jags_example_file]{tar_jags_example_file()}}. The output has a \code{.join_data}
element so the true value of \code{beta} from the simulation
is automatically appended to the \code{beta} rows of the
summary output.
}
\description{
An example dataset compatible with the model file
from \code{\link[=tar_jags_example_file]{tar_jags_example_file()}}. The output has a \code{.join_data}
element so the true value of \code{beta} from the simulation
is automatically appended to the \code{beta} rows of the
summary output.
}
\details{
The \code{tar_jags_example_data()} function draws a JAGS
dataset from the prior predictive distribution of the
model from \code{\link[=tar_jags_example_file]{tar_jags_example_file()}}. First, the
regression coefficient \code{beta} is drawn from its standard
normal prior, and the covariate \code{x} is computed.
Then, conditional on the \code{beta} draws and the covariate,
the response vector \code{y} is drawn from its
Normal(\code{x * beta}, 1) likelihood.
}
\examples{
tar_jags_example_data()
}
