% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{colNum2excelName}
\alias{colNum2excelName}
\title{convert column number to 'Excel' column name}
\usage{
colNum2excelName(x, useLetters = LETTERS, zeroVal = "a", ...)
}
\arguments{
\item{x}{\code{integer} vector}

\item{useLetters}{\code{character} vector of single-digit characters to use as
digits in the resulting column name. Note that these characters can
be of almost any length, with any content.}

\item{zeroVal}{\code{character} single-digit to be used whenever \code{x==0}, or as a
prefix for negative values. In theory there should be no negative
input values, but this basic mechanism is used to handle the possibility.}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{character} vector with length(x)
}
\description{
convert column number to 'Excel' column name
}
\details{
The purpose is to convert an \code{integer} column number into a valid 'Excel'
column name, using \code{LETTERS} starting at A.
This function implements an arbitrary number of digits, which may or
may not be compatible with each version of 'Excel'.  18,278 columns
would be the maximum for three digits, "A" through "ZZZ".

This function is useful when referencing 'Excel' columns via another
interface such as via openxlsx. It is also used by \code{makeNames()}
when the \code{numberStyle="letters"}, in order to provide letter suffix values.

One can somewhat manipulate the allowed column names via the \code{useLetters}
argument, which by default uses the entire 26-letter Western alphabet.
}
\examples{
colNum2excelName(1:30)

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
