% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{hcl2col}
\alias{hcl2col}
\title{convert HCL to R color}
\usage{
hcl2col(
  x = NULL,
  H = NULL,
  C = NULL,
  L = NULL,
  ceiling = 255,
  maxColorValue = 255,
  alpha = NULL,
  fixup = TRUE,
  model = getOption("jam.model", c("hcl", "polarLUV", "polarLAB")),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{matrix of colors, with rownames \code{"H"}, \code{"C"}, \code{"L"}, or if not
supplied it looks for vectors \code{H}, \code{C}, and \code{L} accordingly. It can
alternatively be supplied as an object of class \code{polarLUV}.}

\item{H, C, L}{numeric vectors supplied as an alternative to \code{x}, with
ranges 0 to 360, 0 to 100, and 0 to 100, respectively.}

\item{ceiling}{numeric value indicating the maximum values allowed for
\code{R}, \code{G}, and \code{B} after conversion by \code{colorspace::as(x, "RGB")}.
This ceiling is applied after the \code{maxColorValue} is used to scale
numeric values, and is intended to correct for the occurrence of
values above 255, which would be outside the typical color gamut
allowed for RGB colors used in R. In general, this value should not
be modified.}

\item{maxColorValue}{numeric value indicating the maximum RGB values,
typically scaling values to a range of 0 to 255, from the default
returned range of 0 to 1. In general, this value should not be
modified.}

\item{alpha}{optional vector of alpha values. If not supplied, and if
\code{x} is supplied as a matrix with rowname \code{"alpha"}, then values will
be used from \code{x["alpha",]}.}

\item{fixup}{boolean indicating whether to use
\code{colorspace::hex(...,fixup=TRUE)} for conversion to R hex colors,
\strong{which is not recommended} since this conversion applies some
unknown non-linear transformation for colors outside the color gamut.
It is here is an option for comparison, and if specifically needed.}

\item{model}{\code{character} string indicating the color model to use:
\itemize{
\item hcl (default) uses \code{farver}
\item polarLUV uses \code{colorspace} polarLUV
\item polarLAB uses `colorspace polarLAB
}}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{...}{other arguments are ignored.}
}
\value{
vector of R colors, or where the input was NA, then NA
values are returned in the same order.
}
\description{
Convert an HCL color matrix to vector of R hex colors
}
\details{
This function takes an HCL matrix,and converts to an R color using
the colorspace package \code{colorspace::polarLUV()} and \code{colorspace::hex()}.

When \code{model="hcl"} this function uses \code{farver::encode_colour()}
and bypasses \code{colorspace}. In future the \code{colorspace} dependency
will likely be removed in favor of using \code{farver}. In any event,
\code{model="hcl"} is equivalent to using \code{model="polarLUV"} and
\code{fixup=TRUE}, except that it should be much faster.
}
\examples{
# Prepare a basic HCL matrix
hclM <- col2hcl(c(red="red",
   blue="blue",
   yellow="yellow",
   orange="#FFAA0066"));
hclM;

# Now convert back to R hex colors
colorV <- hcl2col(hclM);
colorV;

showColors(colorV);

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
