% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-mixedSort.R
\name{mixedSortDF}
\alias{mixedSortDF}
\title{sort data.frame keeping numeric values in proper order}
\usage{
mixedSortDF(
  df,
  byCols = seq_len(ncol(df)),
  na.last = TRUE,
  decreasing = NULL,
  useRownames = FALSE,
  verbose = FALSE,
  blanksFirst = TRUE,
  keepNegative = FALSE,
  keepInfinite = FALSE,
  keepDecimal = FALSE,
  ignore.case = TRUE,
  useCaseTiebreak = TRUE,
  sortByName = FALSE,
  honorFactor = TRUE,
  ...
)
}
\arguments{
\item{df}{\code{data.frame} input}

\item{byCols}{one of two types of input:
\enumerate{
\item \code{integer} vector referring to the order of columns to be
used by \code{mmixedOrder()} to order the \code{data.frame}. Note that
negative values will reverse the sort order for the corresponding
column number. To sort \code{rownames(df)} use zero \code{0}, and to reverse
sorting \code{rownames(x)} use \code{-0.1} where the negative sign will
reverse the sort, and \code{-0.1} will be rounded to \code{0}.
\item \code{character} vector of values in \code{colnames(df)},
optionally including prefix \code{"-"} to reverse the sort.
Note that the argument \code{decreasing} can also be used to specify
columns to have reverse sort, either as a single value or vector
to be applied to each column in \code{byCols}. To sort \code{rownames(df)}
use \code{"rownames"} or \code{"row.names"}. To reverse sorting \code{rownames(df)}
use \code{"-rownames"} or \code{"-row.names"}.
}}

\item{na.last}{\code{logical} whether to move NA entries to the end of the sort.
When \code{na.last=TRUE} then \code{NA} values will always be last, even following
blanks and infinite values. When \code{na.last=FALSE} then \code{NA} values
will always be first, even before blanks and negative infinite values.}

\item{decreasing}{NULL or \code{logical} vector indicating which columns
in \code{byCols} should be sorted in decreasing order. By default, the
\code{sign(byCols)} is used to define the sort order of each column, but it
can be explicitly overridden with this \code{decreasing} parameter.}

\item{useRownames}{\code{logical} whether to use \code{rownames(df)} as a last
tiebreaker in the overall rank ordering. This parameter has the primary
effect of assuring a reproducible result, provided the rownames are
consistently defined, or if rownames are actually row numbers.
When \code{useRownames=FALSE} then rows that would otherwise be ties
will be returned in the same order they were provided in \code{df}.}

\item{verbose}{\code{logical} whether to print verbose output. When
\code{verbose=2} there is slightly more verbose output.}

\item{blanksFirst, keepNegative, keepInfinite, keepDecimal, ignore.case, useCaseTiebreak, sortByName}{arguments passed to \code{mmixedOrder()}, except \code{sortByName} which is not
passed along.}

\item{honorFactor}{\code{logical}, default TRUE, indicating whether to honor
factor level order in the output, otherwise when FALSE it sorts
as \code{character}.}

\item{...}{additional arguments passed to \code{mmixedOrder()} for custom
sort options as described in \code{mixedSort()}.}
}
\value{
\code{data.frame} whose rows are ordered using \code{mmixedOrder()}.
}
\description{
sort data.frame keeping numeric values in proper order
}
\details{
This function is a wrapper around \code{mmixedOrder()} so it operates
on \code{data.frame} columns in the proper order, using logic similar that used
by \code{base::order()} when operating on a \code{data.frame}. The sort order logic
is fully described in \code{mixedSort()} and \code{mixedOrder()}.

Note that \code{byCols} can either be given as \code{integer} column index values,
or \code{character} vector of \code{colnames(x)}. In either case, using negative
prefix \code{-} will reverse the sort order of the corresponding column.

For example \code{byCols=c(2, -1)} will sort column 2 increasing, then
column 1 decreasing.

Similarly, one can supply \code{colnames(df)}, such as
\code{byCols=c("colname2", "-colname1")}. Values are matched as-is to
\code{colnames(df)} first, then any values not matched are compared again
after removing prefix \code{-} from the start of each \code{character} string.
Therefore, if \code{colnames(df)} contains \code{"-colname1"} it will be matched
as-is, but \code{"--colname1"} will only be matched after removing the first \code{-},
after which the sort order will be reversed for that column.

For direct control over the sort order of each column defined in \code{byCols},
you can supply \code{logical} vector to argument \code{decreasing}, and this vector
is recycled to \code{length(byCols)}.

Finally, for slight efficiency, only unique columns defined in \code{byCols}
are used to determine the row order, so even if a column is defined twice
in \code{byCols}, only the first instance is passed to \code{mmixedOrder()} to
determine row order.
}
\examples{
# start with a vector of miRNA names
x <- c("miR-12","miR-1","miR-122","miR-1b", "miR-1a","miR-2");
# add some arbitrary group information
g <- rep(c("Air", "Treatment", "Control"), 2);
# create a data.frame
df <- data.frame(group=g,
   miRNA=x,
   stringsAsFactors=FALSE);

# input data
df;

# output when using order()
df[do.call(order, df), , drop=FALSE];

# output with mixedSortDF()
mixedSortDF(df);

# mixedSort respects factor order
# reorder factor levels to demonstrate.
# "Control" should come first
gf <- factor(g, levels=c("Control", "Air", "Treatment"));
df2 <- data.frame(groupfactor=gf,
   miRNA=x,
   stringsAsFactors=FALSE);

# now the sort properly keeps the group factor levels in order,
# which also sorting the miRNA names in their proper order.
mixedSortDF(df2);


x <- data.frame(l1=letters[1:10],
   l2=rep(letters[1:2+10], 5),
   L1=LETTERS[1:10],
   L2=rep(LETTERS[1:2+20], each=5));
set.seed(123);
rownames(x) <- sample(seq_len(10));
x;

# sort by including rownames
mixedSortDF(x, byCols=c("rownames"));
mixedSortDF(x, byCols=c("L2", "-rownames"));

# demonstrate sorting a matrix with no rownames
m <- matrix(c(2, 1, 3, 4), ncol=2);
mixedSortDF(m, byCols=-2)

# add rownames
rownames(m) <- c("c", "a");
mixedSortDF(m, byCols=0)
mixedSortDF(m, byCols="-rownames")
mixedSortDF(m, byCols="rownames")

mixedSortDF(data.frame(factor1=factor(c("Cnot9", "Cnot8", "Cnot10"))), honorFactor=FALSE)

# test date columns
testfiles <- system.file(package="jamba", c("TODO.md", "README.md", "NEWS.md"))
testinfo <- file.info(testfiles)
testinfo
mixedSortDF(testinfo, byCols="mtime")

}
\seealso{
Other jam sort functions: 
\code{\link{mixedOrder}()},
\code{\link{mixedSort}()},
\code{\link{mixedSorts}()},
\code{\link{mmixedOrder}()}
}
\concept{jam sort functions}
