% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_crosstab.R
\name{adorn_crosstab}
\alias{adorn_crosstab}
\title{Add formatting to a crosstabulation table.}
\usage{
adorn_crosstab(crosstab, denom = "row", show_n = TRUE, digits = 1,
  show_totals = FALSE, rounding = "half to even")
}
\arguments{
\item{crosstab}{a data.frame with row names in the first column and numeric values in all other columns.  Usually the piped-in result of a call to  \code{crosstab} that included the argument \code{percent = "none"}.}

\item{denom}{the denominator to use for calculating percentages.  One of "row", "col", or "all".}

\item{show_n}{should counts be displayed alongside the percentages?}

\item{digits}{how many digits should be displayed after the decimal point?}

\item{show_totals}{display a totals summary? Will be a row, column, or both depending on the value of \code{denom}.}

\item{rounding}{method to use for truncating percentages - either "half to even", the base R default method, or "half up", where 14.5 rounds up to 15.}
}
\value{
Returns a data.frame.
}
\description{
Designed to run on the output of a call to \code{crosstab}, this adds formatting, percentage sign, Ns, totals row/column, and custom rounding to a table of numeric values.  The result is no longer clean data, but it saves time in reporting table results.
}
\examples{
library(dplyr) # for the \%>\% pipe
mtcars \%>\%
 crosstab(gear, cyl) \%>\%
 adorn_crosstab(denom = "all")
 
# showing with all parameters
mtcars \%>\%
 crosstab(gear, cyl) \%>\%
 adorn_crosstab(., denom = "col", rounding = "half up", show_n = FALSE, digits = 2)
mtcars \%>\%
 crosstab(cyl, am) \%>\%
 adorn_crosstab(., denom = "all", digits = 0, rounding = "half up") 
}

