% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_totals.R
\name{adorn_totals}
\alias{adorn_totals}
\title{Append a totals row and/or column to a data.frame.}
\usage{
adorn_totals(dat, which = c("row", "col"), fill = "-", na.rm = TRUE)
}
\arguments{
\item{dat}{an input data.frame with at least one numeric column.}

\item{which}{one of "row", "col", or \code{c("row", "col")}}

\item{fill}{if there are multiple non-numeric columns, what string should fill the bottom row of those columns?}

\item{na.rm}{should missing values (including NaN) be omitted from the calculations?}
}
\value{
Returns a data.frame augmented with a totals row, column, or both.
}
\description{
This function excludes the first column of the input data.frame, assuming it's a descriptive variable not to be summed.  It also excludes other non-numeric columns.
}
\examples{
mtcars \%>\%
  crosstab(am, cyl) \%>\%
  adorn_totals()
}
