% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{longcovid}
\alias{longcovid}
\title{Meta-analysis: Long-COVID Health Outcomes}
\format{
A data frame with 271 rows and 27 columns. Each row represents the results of a single study.
The columns include:
\describe{
  \item{study}{Name of the first author and publication year.}
  \item{category}{Category of the health outcome.}
  \item{outcome_disease}{Definition of the health outcome or disease.}
  \item{data_source}{Type of data source: Administrative data, Health records, Patients claims, Survey, Combination of health records and claims. }
  \item{sample_size}{Total number of participants.}
  \item{effect_type}{Type of effect reported: RR (Relative Risk), HR (Hazard Ratio), or OR (Odds Ratio).}
  \item{effect}{Estimated effect based on the effect type.}
  \item{TE}{Logarithm of the estimated effect.}
  \item{seTE}{Standard error of the logarithm of the estimated effect.}
  \item{rate_control}{Event rate in the control group.}
  \item{follow_up_time}{Follow-up time in weeks.}
  \item{mean_age}{Mean age of the participants.}
  \item{disease_severity}{Indicator for inclusion of severe or critical disease participants ("no" or "yes").}
  \item{reinfection}{Indicator for inclusion of reinfected participants ("no" or "yes").}
  \item{no_of_confounders}{Number of confounders for which adjustments were made in the study.}
  \item{uncertainty_of_confounders}{high if ROB4 OR ROB5 is high or unclear or low otherwise.}
  \item{list_of_confounders}{List of confounders considered in the study.}
  \item{ROB1}{Were the two groups similar and recruited from the same population?}
   \item{ROB2}{Were the exposures measured similarly to assign participants to exposed and unexposed groups?}
   \item{ROB3}{Was the exposure measured in a valid and reliable way?}
   \item{ROB4}{Were confounding factors identified?}
   \item{ROB5}{Were strategies to address confounding factors stated?}
   \item{ROB6}{Were the groups/participants free of the outcome at the start of the study (or at the moment of exposure)?}
   \item{ROB7}{Were the outcomes measured in a valid and reliable way?}
   \item{ROB8}{Was the follow-up time reported and sufficient to allow outcomes to occur?}
   \item{ROB9}{Was follow-up complete, and if not, were the reasons for loss to follow-up described and explored?}
   \item{ROB10}{Were strategies to address incomplete follow-up utilized?}
   \item{ROB11}{Was appropriate statistical analysis used?}
}
}
\source{
Franco JVA, Garegnani LI, Metzendorf MI, Heldt K, Mumm R, Scheidt-Nave C.
Post-COVID-19 conditions in adults: systematic review and meta-analysis of health outcomes
in controlled studies. BMJ Medicine. 2024;3:e000723.
}
\description{
This dataset is based on a comprehensive meta-analysis of 33 studies, sourced from various databases,
including the Cochrane COVID-19 Study Register (comprising the Cochrane Central Register of Controlled Trials,
Medline, Embase, clinicaltrials.gov, the World Health Organization's International Clinical Trials Registry Platform,
and medRxiv) and the World Health Organization’s COVID-19 research database. The analysis focused on evaluating
health outcomes related to Long-COVID in controlled studies. Specifically, it examines the health outcomes in
terms of incident medicinal diagnoses.

The dataset includes the assessment of risk of bias based on the Joanna Briggs Institute (JBI) tool for cohort studies,
along with various participant and study details such as sample size, effect type, follow-up time, and disease severity.
}
\keyword{datasets}
