% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jgcricol.R
\name{jgcricol}
\alias{jgcricol}
\title{jgcricol}
\usage{
jgcricol(palx = NULL, alpha = NULL)
}
\arguments{
\item{palx}{Palette name to view the palette jgcricol. e.g. jgcricol(palx="pal_basic")}

\item{alpha}{Default = NULL. Parameter to add transparency.}
}
\value{
A list of color palettes.
}
\description{
This function loads various generic and JGCRI specific color palettes charts and maps.
}
\details{
List of Color Palettes
\itemize{
\item "pal_all"
\item "pal_16"
\item "pal_basic"
\item "pal_hot"
\item "pal_wet"
\item "pal_div_wet"
\item "pal_div_BlRd"
\item "pal_div_RdBl"
\item "pal_div_BrGn"
\item "pal_div_GnBr"
\item "pal_div_BluRd"
\item "pal_div_RdBlu"
\item "pal_green"
\item "pal_div_BrGn"
\item "pal_div_BlRd"
\item "pal_sankey"
\item "pal_spectral"
\item "pal_scarcityCat"}
}
\examples{
library(jgcricolors)
# To see all available palettes
names(jgcricol())
# How to use palettes:
pal1 <- jgcricol()$pal_basic
pal2 <- jgcricol("pal_basic")
pals <- jgcricol()
pal3 <- pals$pal_basic # This way will auto populate the options after pals$
}
