% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{julia_model_tidiers}
\alias{julia_model_tidiers}
\alias{tidy.jlmer_mod}
\alias{glance.jlmer_mod}
\title{Tidier methods for Julia regression models}
\usage{
\method{tidy}{jlmer_mod}(x, effects = c("var_model", "ran_pars", "fixed"), ...)

\method{glance}{jlmer_mod}(x, ...)
}
\arguments{
\item{x}{An object of class \code{jlmer_mod}}

\item{effects}{One of "var_model", "ran_pars", or "fixed"}

\item{...}{Unused}
}
\value{
A data frame
}
\description{
Tidier methods for Julia regression models
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(cache_dir = tempdir(), verbose = FALSE)
julia_progress(show = FALSE)
}

# Fixed-effects only model
mod1 <- to_jlmer(weight ~ 1 + Diet, ChickWeight)
tidy(mod1)
glance(mod1)

# Mixed model
mod2 <- to_jlmer(weight ~ 1 + Diet + (1 | Chick), ChickWeight)
tidy(mod2)
glance(mod2)

# Select which of fixed/random effects to return
tidy(mod2, effects = "fixed")
tidy(mod2, effects = "ran_pars")

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
