% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia_rng.R
\name{julia_rng}
\alias{julia_rng}
\alias{set_rng_state}
\alias{reset_rng_state}
\alias{get_rng_state}
\alias{set_rng_seed}
\alias{get_rng_seed}
\title{Interface to the Julia RNG}
\usage{
set_rng_state(i)

reset_rng_state()

get_rng_state()

set_rng_seed(seed)

get_rng_seed()
}
\arguments{
\item{i}{Counter number}

\item{seed}{Seed}
}
\value{
The current seed or counter
}
\description{
Interface to the Julia RNG
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(cache_dir = tempdir(), verbose = FALSE)
julia_progress(show = FALSE)
}

# RNG initializes to seed=1 counter=0
get_rng_seed()
get_rng_state()

# setter/getter for RNG counter
set_rng_state(123)
get_rng_state()

# setter/getter for RNG seed
set_rng_seed(2)
get_rng_seed()

# restore to initial setting (seed=1, counter=0)
set_rng_seed(1)
set_rng_state(0)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
