% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_scales.R
\name{ggplot2-scales}
\alias{ggplot2-scales}
\alias{scale_color_jma_absolute}
\alias{scale_color_jma_relative}
\alias{scale_fill_jma_absolute}
\alias{scale_fill_jma_relative}
\title{Scales to use for ggplot2}
\usage{
scale_color_jma_absolute(type = "precipitation", ...)

scale_color_jma_relative(type = "amedas", ...)

scale_fill_jma_absolute(type = "precipitation", ...)

scale_fill_jma_relative(type = "amedas", ...)
}
\arguments{
\item{type}{Display item}

\item{...}{Arguments to pass on to \link[ggplot2:scale_gradient]{ggplot2::scale_color_gradientn} or
\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradientn}}
}
\value{
A \code{ScaleContinuous} object that can be added to a \code{ggplot} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
d <-
data.frame(
  date = as.Date(c(17410, 17411, 17412, 17413, 17414, 17415), origin = "1970-01-01"),
  precipitation_sum = units::set_units(c(3.5, 9.5, 0, 0, 0, 5), "mm"))

library(ggplot2)
library(units)
ggplot(d, aes(date, precipitation_sum,
          color = drop_units(precipitation_sum),
          fill = drop_units(precipitation_sum))) +
  geom_bar(stat = "identity") +
  scale_color_jma_absolute(type = "precipitation") +
  scale_fill_jma_absolute(type = "precipitation")
}
