% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetJRow}
\alias{GetJRow}
\title{GetJRow}
\usage{
GetJRow(fname, nrow)
}
\arguments{
\item{fname}{String with the file name that contains the binary data.}

\item{nrow}{The number of the row to be returned, in R-numbering (from 1)}
}
\value{
A numeric vector with the values of elements in the requested row
}
\description{
Returns (as a R numeric vector) the requested row number from the matrix contained in a jmatrix binary file
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
Rf[3,]
vf<-GetJRow("Rfullfloat.bin",3)
vf
file.remove("Rfullfloat.bin")
}
