
# This file is automatically generated, you probably don't want to edit this

corrMatrixOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "corrMatrixOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            pearson = TRUE,
            spearman = FALSE,
            kendall = FALSE,
            sig = TRUE,
            flag = FALSE,
            n = FALSE,
            ci = FALSE,
            ciWidth = 95,
            plots = FALSE,
            plotDens = FALSE,
            plotStats = FALSE,
            hypothesis = "corr", ...) {

            super$initialize(
                package="jmv",
                name="corrMatrix",
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                takeFromDataIfMissing=TRUE,
                suggested=list(
                    "continuous",
                    "ordinal"),
                permitted=list(
                    "numeric",
                    "factor"))
            private$..pearson <- jmvcore::OptionBool$new(
                "pearson",
                pearson,
                default=TRUE)
            private$..spearman <- jmvcore::OptionBool$new(
                "spearman",
                spearman,
                default=FALSE)
            private$..kendall <- jmvcore::OptionBool$new(
                "kendall",
                kendall,
                default=FALSE)
            private$..sig <- jmvcore::OptionBool$new(
                "sig",
                sig,
                default=TRUE)
            private$..flag <- jmvcore::OptionBool$new(
                "flag",
                flag,
                default=FALSE)
            private$..n <- jmvcore::OptionBool$new(
                "n",
                n,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..plotDens <- jmvcore::OptionBool$new(
                "plotDens",
                plotDens,
                default=FALSE)
            private$..plotStats <- jmvcore::OptionBool$new(
                "plotStats",
                plotStats,
                default=FALSE)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "corr",
                    "pos",
                    "neg"),
                default="corr")

            self$.addOption(private$..vars)
            self$.addOption(private$..pearson)
            self$.addOption(private$..spearman)
            self$.addOption(private$..kendall)
            self$.addOption(private$..sig)
            self$.addOption(private$..flag)
            self$.addOption(private$..n)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..plots)
            self$.addOption(private$..plotDens)
            self$.addOption(private$..plotStats)
            self$.addOption(private$..hypothesis)
        }),
    active = list(
        vars = function() private$..vars$value,
        pearson = function() private$..pearson$value,
        spearman = function() private$..spearman$value,
        kendall = function() private$..kendall$value,
        sig = function() private$..sig$value,
        flag = function() private$..flag$value,
        n = function() private$..n$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        plots = function() private$..plots$value,
        plotDens = function() private$..plotDens$value,
        plotStats = function() private$..plotStats$value,
        hypothesis = function() private$..hypothesis$value),
    private = list(
        ..vars = NA,
        ..pearson = NA,
        ..spearman = NA,
        ..kendall = NA,
        ..sig = NA,
        ..flag = NA,
        ..n = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..plots = NA,
        ..plotDens = NA,
        ..plotStats = NA,
        ..hypothesis = NA)
)

corrMatrixResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "corrMatrixResults",
    inherit = jmvcore::Group,
    active = list(
        matrix = function() private$.items[["matrix"]],
        plot = function() private$.items[["plot"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Correlation Matrix")
            self$add(jmvcore::Table$new(
                options=options,
                name="matrix",
                title="Correlation Matrix",
                rows="(vars)",
                clearWith=list(
                    "ciWidth",
                    "hypothesis",
                    "flag"),
                columns=list(
                    list(
                        `name`=".name[r]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(pearson)"),
                    list(
                        `name`=".stat[r]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Pearson's r", 
                        `visible`="(pearson && (sig || spearman || kendall || ci || n))"),
                    list(
                        `name`=".name[rdf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(pearson && sig)"),
                    list(
                        `name`=".stat[rdf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="df", 
                        `visible`="(pearson && sig)"),
                    list(
                        `name`=".name[rp]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(pearson && sig)"),
                    list(
                        `name`=".stat[rp]", 
                        `title`="", 
                        `type`="text", 
                        `content`="p-value", 
                        `visible`="(pearson && sig)"),
                    list(
                        `name`=".name[rciu]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(pearson && ci)"),
                    list(
                        `name`=".stat[rciu]", 
                        `title`="", 
                        `type`="text", 
                        `content`="CI Upper", 
                        `visible`="(pearson && ci)"),
                    list(
                        `name`=".name[rcil]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(pearson && ci)"),
                    list(
                        `name`=".stat[rcil]", 
                        `title`="", 
                        `type`="text", 
                        `content`="CI Lower", 
                        `visible`="(pearson && ci)"),
                    list(
                        `name`=".name[rho]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(spearman)"),
                    list(
                        `name`=".stat[rho]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Spearman's rho", 
                        `visible`="(spearman && (sig || pearson || kendall || n))"),
                    list(
                        `name`=".name[rhodf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(spearman && sig)"),
                    list(
                        `name`=".stat[rhodf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="df", 
                        `visible`="(spearman && sig)"),
                    list(
                        `name`=".name[rhop]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(spearman && sig)"),
                    list(
                        `name`=".stat[rhop]", 
                        `title`="", 
                        `type`="text", 
                        `content`="p-value", 
                        `visible`="(spearman && sig)"),
                    list(
                        `name`=".name[tau]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(kendall)"),
                    list(
                        `name`=".stat[tau]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Kendall's Tau B", 
                        `visible`="(kendall && (sig || pearson || spearman || n))"),
                    list(
                        `name`=".name[taup]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(kendall && sig)"),
                    list(
                        `name`=".stat[taup]", 
                        `title`="", 
                        `type`="text", 
                        `content`="p-value", 
                        `visible`="(kendall && sig)"),
                    list(
                        `name`=".name[n]", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)", 
                        `combineBelow`=TRUE, 
                        `visible`="(n)"),
                    list(
                        `name`=".stat[n]", 
                        `title`="", 
                        `type`="text", 
                        `content`="N", 
                        `visible`="(n)"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="plot",
                title="Plot",
                visible="(plots)",
                width=500,
                height=500,
                renderFun=".plot",
                requiresData=TRUE,
                clearWith=list(
                    "vars",
                    "plotDens",
                    "plotStats",
                    "pearson",
                    "spearman",
                    "kendall")))}))

corrMatrixBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "corrMatrixBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "jmv",
                name = "corrMatrix",
                version = c(1,0,0),
                options = options,
                results = corrMatrixResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE,
                weightsSupport = 'auto')
        }))

#' Correlation Matrix
#'
#' Correlation matrices are a way to examine linear relationships between
#' two or more continuous variables.
#' 
#' For each pair of variables, a Pearson's r value indicates the strength
#' and direction of the relationship between those two variables. A
#' positive value indicates a positive relationship (higher values of one
#' variable predict higher values of the other variable). A negative
#' Pearson's r indicates a negative relationship (higher values of one
#' variable predict lower values of the other variable, and vice-versa).
#' A value of zero indicates no relationship (whether a variable is high
#' or low, does not tell us anything about the value of the other
#' variable).
#' 
#' More formally, it is possible to test the null hypothesis that the
#' correlation is zero and calculate a p-value. If the p-value is low, it
#' suggests the correlation co-efficient is not zero, and there is a linear
#' (or more complex) relationship between the two variables.
#' 
#'
#' @examples
#' \donttest{
#' data('mtcars')
#'
#' corrMatrix(mtcars, vars = vars(mpg, cyl, disp, hp))
#'
#' #
#' #  CORRELATION MATRIX
#' #
#' #  Correlation Matrix
#' #  --------------------------------------------------------------
#' #                           mpg      cyl       disp      hp
#' #  --------------------------------------------------------------
#' #    mpg     Pearson's r        —    -0.852    -0.848    -0.776
#' #            p-value            —    < .001    < .001    < .001
#' #
#' #    cyl     Pearson's r                  —     0.902     0.832
#' #            p-value                      —    < .001    < .001
#' #
#' #    disp    Pearson's r                            —     0.791
#' #            p-value                                —    < .001
#' #
#' #    hp      Pearson's r                                      —
#' #            p-value                                          —
#' #  --------------------------------------------------------------
#' #
#'}
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables to correlate in
#'   \code{data}
#' @param pearson \code{TRUE} (default) or \code{FALSE}, provide Pearson's R
#' @param spearman \code{TRUE} or \code{FALSE} (default), provide Spearman's
#'   rho
#' @param kendall \code{TRUE} or \code{FALSE} (default), provide Kendall's
#'   tau-b
#' @param sig \code{TRUE} (default) or \code{FALSE}, provide significance
#'   levels
#' @param flag \code{TRUE} or \code{FALSE} (default), flag significant
#'   correlations
#' @param n \code{TRUE} or \code{FALSE} (default), provide the number of cases
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals to provide
#' @param plots \code{TRUE} or \code{FALSE} (default), provide a correlation
#'   matrix plot
#' @param plotDens \code{TRUE} or \code{FALSE} (default), provide densities in
#'   the correlation matrix plot
#' @param plotStats \code{TRUE} or \code{FALSE} (default), provide statistics
#'   in the correlation matrix plot
#' @param hypothesis one of \code{'corr'} (default), \code{'pos'},
#'   \code{'neg'} specifying the alernative hypothesis; correlated, correlated
#'   positively, correlated negatively respectively.
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$matrix} \tab \tab \tab \tab \tab a correlation matrix table \cr
#'   \code{results$plot} \tab \tab \tab \tab \tab a correlation matrix plot \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$matrix$asDF}
#'
#' \code{as.data.frame(results$matrix)}
#'
#' @export
corrMatrix <- function(
    data,
    vars,
    pearson = TRUE,
    spearman = FALSE,
    kendall = FALSE,
    sig = TRUE,
    flag = FALSE,
    n = FALSE,
    ci = FALSE,
    ciWidth = 95,
    plots = FALSE,
    plotDens = FALSE,
    plotStats = FALSE,
    hypothesis = "corr") {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("corrMatrix requires jmvcore to be installed (restart may be required)")

    if ( ! missing(vars)) vars <- jmvcore::resolveQuo(jmvcore::enquo(vars))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL))

    vars <- `if`( ! missing(vars), vars, colnames(data))

    options <- corrMatrixOptions$new(
        vars = vars,
        pearson = pearson,
        spearman = spearman,
        kendall = kendall,
        sig = sig,
        flag = flag,
        n = n,
        ci = ci,
        ciWidth = ciWidth,
        plots = plots,
        plotDens = plotDens,
        plotStats = plotStats,
        hypothesis = hypothesis)

    analysis <- corrMatrixClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

