% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long2wide_omv.R
\name{long2wide_omv}
\alias{long2wide_omv}
\title{Converts .omv-files for the statistical spreadsheet 'jamovi' (www.jamovi.org) from long to wide format}
\usage{
long2wide_omv(
  fleInp = "",
  fleOut = "",
  varID = "",
  varTme = "",
  varTgt = c(),
  varSep = ".",
  varOrd = c("times", "vars"),
  varSrt = c(),
  usePkg = c("foreign", "haven"),
  selSet = "",
  ...
)
}
\arguments{
\item{fleInp}{Name (including the path, if required) of the data file to be read (e.g., "FILE_IN.omv"; default: ""); can be any supported file type, see Details below}

\item{fleOut}{Name (including the path, if required) of the data file to be written (e.g., "FILE_OUT.omv"; default: ""); if empty, FILE_IN from fleInp is extended with "_wide(file extension -> .omv)"}

\item{varID}{Names of one or more variables that identify the same group / individual (default: c())}

\item{varTme}{Name of the variable that differentiates multiple records from the same group / individual (default: "")}

\item{varTgt}{Names of one or more variables to be transformed / reshaped (other variables are excluded, if empty(c()) all variables except varTme and varID are included; default: c())}

\item{varSep}{Separator character when concatenating the fixed and time-varying part of the variable name ("VAR1.1", "VAR1.2"; default: ".")}

\item{varOrd}{How variables / columns are organized: for "times" (default) the steps of the time varying variable are adjacent, for "vars" the steps of the original columns in the long dataset}

\item{varSrt}{Variable(s) that are used to sort the data frame (see Details; if empty, the order returned from reshape is kept; default: c())}

\item{usePkg}{Name of the package: "foreign" or "haven" that shall be used to read SPSS, Stata and SAS files; "foreign" is the default (it comes with base R), but "haven" is newer and more comprehensive}

\item{selSet}{Name of the data set that is to be selected from the workspace (only applies when reading .RData-files)}

\item{...}{Additional arguments passed on to methods; see Details below}
}
\description{
Converts .omv-files for the statistical spreadsheet 'jamovi' (www.jamovi.org) from long to wide format
}
\details{
The ellipsis-parameter (...) can be used to submit arguments / parameters to the functions that are used for transforming or reading the data. The transformation uses \code{reshape}. When reading the
data, the functions are: \code{read_omv} (for jamovi-files), \code{read.table} (for CSV / TSV files; using similar defaults as \code{read.csv} for CSV and \code{read.delim} for TSV which both are based upon
\code{read.table} but with adjusted defaults for the respective file types), \code{readRDS} (for rds-files), \code{read_sav} (needs R-package "haven") or \code{read.spss} (needs R-package "foreign") for SPSS-files,
\code{read_dta} ("haven") / \code{read.dta} ("foreign") for Stata-files, \code{read_sas} ("haven") for SAS-data-files, and \code{read_xpt} ("haven") / \code{read.xport} ("foreign") for SAS-transport-files. If you would
like to use "haven", it may be needed to install it manually (i.e., \code{install.packages("haven", dep = TRUE)}).
}
\examples{
\dontrun{
library(jmvReadWrite);
# generate a test dataframe with 100 (imaginary) participants / units of
#  observation (ID), 8 measurement (Meas) of one variable (X)
dtaInp <- data.frame(ID = sort(rep(seq(1:100), 8)),
                     Meas = rep(seq(1, 8), 100),
                     X = runif(800, -10, 10));
cat(str(dtaInp));
# the output should look like this
# 'data.frame': 800 obs. of  3 variables:
#  $ ID  : int  1 1 1 1 1 1 1 1 2 2 ...
#  $ Meas: int  1 2 3 4 5 6 7 8 1 2 ...
#  $ X   : num  ...
# this data set is stored as (temporary) RDS-file and later processed by long2wide
nmeInp <- paste0(tempfile(), ".rds");
nmeOut <- paste0(tempfile(), ".omv");
saveRDS(dtaInp, nmeInp);
long2wide_omv(fleInp = nmeInp, fleOut = nmeOut, varID = "ID", varTme = "Meas", varTgt = "X");
# it is required to give at least the arguments fleInp, varID and varTme
# check whether the file was created and its size
cat(list.files(dirname(nmeOut), basename(nmeOut)));
# -> "file[...].omv" ([...] contains a random combination of numbers / characters
cat(file.info(nmeOut)$size);
# -> 6200 (approximate size; size may differ in every run [in dependence of
#          how well the generated random data can be compressed])
cat(str(read_omv(nmeOut, sveAtt = FALSE)));
# the data set is now transformed into wide (and each the measurements is now
# indicated as a suffix to X; X.1, X.2, ...)
# 'data.frame':	100 obs. of  9 variables:
#  $ ID : int  1 2 3 4 5 6 7 8 9 10 ...
#   ..- attr(*, "jmv-id")= logi TRUE
#   ..- attr(*, "missingValues")= list()
#  $ X.1: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.2: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.3: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.4: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.5: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.6: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.7: num  ...
#   ..- attr(*, "missingValues")= list()
#  $ X.8: num  ...
#   ..- attr(*, "missingValues")= list()

unlink(nmeInp);
unlink(nmeOut);
}

}
