% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpose_omv.R
\name{transpose_omv}
\alias{transpose_omv}
\title{Transpose .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})}
\usage{
transpose_omv(
  dtaInp = NULL,
  fleOut = "",
  nmeVar = "",
  usePkg = c("foreign", "haven"),
  selSet = "",
  ...
)
}
\arguments{
\item{dtaInp}{Either a data frame or the name (including the path, if required) of a data file to be read ("FILENAME.ext"; default: NULL); files can be of any supported file type, see Details below}

\item{fleOut}{Name (including the path, if required) of the data file to be written ("FILENAME.omv"; default: ""); if empty, and a file name is given as dtaInp, it is appended with "_xpsd.omv"}

\item{nmeVar}{Name of the variables in the output data frame; see Details below}

\item{usePkg}{Name of the package: "foreign" or "haven" that shall be used to read SPSS, Stata and SAS files; "foreign" is the default (it comes with base R), but "haven" is newer and more comprehensive}

\item{selSet}{Name of the data set that is to be selected from the workspace (only applies when reading .RData-files)}

\item{...}{Additional arguments passed on to methods; see Details below}
}
\description{
Transpose .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})
}
\details{
If nmeVar empty, the row names of the input data set are used (preceded by "V_" if all row names are numbers); if nmeVar has the length 1 then it is supposed to point to a variable in the input
data frame; if nmeVar has the same length as the number of rows in the input data frame, then the values in nmeVar are assigned as column names to the output data frame.
The ellipsis-parameter can be used to submit arguments / parameters to the functions that are used for reading the data. These are: \code{read_omv} (for jamovi-files), \code{read.table} (for CSV / TSV
files; using similar defaults as \code{read.csv} for CSV and \code{read.delim} for TSV which both are based upon \code{read.table} but with adjusted defaults for the respective file types), \code{readRDS} (for
rds-files), \code{read_sav} (needs R-package "haven") or \code{read.spss} (needs R-package "foreign") for SPSS-files, \code{read_dta} ("haven") / \code{read.dta} ("foreign") for Stata-files, \code{read_sas} ("haven") for
SAS-data-files, and \code{read_xpt} ("haven") / \code{read.xport} ("foreign") for SAS-transport-files. If you would like to use "haven", it may be needed to install it manually
(i.e., \code{install.packages("haven", dep = TRUE)}).
}
\examples{
\dontrun{
library(jmvReadWrite)
set.seed(1)
tmpDF <- stats::setNames(as.data.frame(matrix(sample(6, 1200, replace = TRUE), nrow = 16)),
                         sprintf("sbj_\%03d", seq(75)))
str(tmpDF)
# Data sets that were extracted, e.g., from PsychoPy, may look like this (trials as rows
# and participants as columns, one for each participant, manually assmebled / copy-and-pasted).
# However, for analyses, one wants the data set transposed (units / participants as columns)...
fleTmp <- paste0(tempfile(), ".omv")
transpose_omv(dtaInp = tmpDF, fleOut = fleTmp)
dtaFrm <- read_omv(fleTmp)
str(dtaFrm)
# if no nmeVar-parameter is given, generic variable names are created (V_...)
transpose_omv(dtaInp = tmpDF, fleOut = fleTmp, nmeVar = sprintf("Trl_\%02d", seq(16)))
dtaFrm <- read_omv(fleTmp)
str(dtaFrm)
# alternatively, the character vector with the desired variable names (of the same length as
# the number of rows in tmpDF) may be given, "Trl" can easily be exchanged by the name of your
# questionnaire, experimental conditions, etc.
unlink(fleTmp)
}

}
