% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{Simulate data from a joint model}
\usage{
simData(n = 100, ntms = 5, beta = rbind(c(1, 1, 1, 1), c(1, 1, 1, 1)),
  gamma.x = c(1, 1), gamma.y = c(0.5, -1), sigma2 = c(1, 1), D = NULL,
  df = Inf, model = "intslope", theta0 = -3, theta1 = 1,
  censoring = TRUE, censlam = exp(-3), truncation = TRUE,
  trunctime = (ntms - 1) + 0.1)
}
\arguments{
\item{n}{the number of subjects to simulate data for.}

\item{ntms}{the maximum number of (discrete) time points to simulate repeated
longitudinal measurements at.}

\item{beta}{a matrix of \code{dim=c(K,4)} specifying the coefficients of the
fixed effects. The order in each row is intercept, time, a continuous
covariate, and a binary covariate.}

\item{gamma.x}{a vector of \code{length=2} specifying the coefficients for
the time-to-event baseline covariates, in the order of a continuous
covariate and a binary covariate.}

\item{gamma.y}{a vector of \code{length=K} specifying the latent association
parameters for each longitudinal outcome.}

\item{sigma2}{a vector of \code{length=K} specifying the residual standard
errors.}

\item{D}{a positive-definite matrix specifying the variance-covariance
matrix. If \code{model='int'}, the matrix has dimension \code{dim=c(K, K)},
else if \code{model='intslope'}, the matrix has dimension \code{dim =c(2K,
2K)}. If \code{D=NULL} (default), an identity matrix is assumed.}

\item{df}{a non-negative scalar specifying the degrees of freedom for the
random effects if sampled from a multivariate \emph{t}-distribution. The
default is \code{df=Inf}, which corresponds to a multivariate normal
distribution.}

\item{model}{follows the model definition in the \code{\link[joineR]{joint}}
function. See \strong{Details} for choices.}

\item{theta0, theta1}{parameters controlling the failure rate. See Details.}

\item{censoring}{logical: if \code{TRUE}, includes an independent censoring
time.}

\item{censlam}{a scale (\eqn{> 0}) parameter for an exponential distribution
used to simulate random censoring times for when \code{censoring=TRUE}.}

\item{truncation}{logical: if \code{TRUE}, adds a truncation time for a
maximum event time.}

\item{trunctime}{a truncation time for use when \code{truncation=TRUE}.}
}
\value{
A list of 2 \code{data.frame}s: one recording the requisite
  longitudinal outcomes data, and one recording the time-to-event data.
}
\description{
This function simulates multivariate longitudinal and
  time-to-event data from a joint model.
}
\details{
The function \code{simData} simulates data from a joint model,
  similar to that performed in Henderson et al. (2000). It works by first
  simulating multivariate longitudinal data for all possible follow-up times
  using random draws for the multivariate Gaussian random effects and
  residual error terms. Data can be simulated assuming either
  random-intercepts only in each of the longitudinal sub-models, or
  random-intercepts and random-slopes. Currently, all models must have the
  same structure. The failure times are simulated from proportional hazards
  time-to-event models using the following methodologies:

  \describe{

  \item{\code{model="int"}}{The baseline hazard function is specified to be
  an exponential distribution with

  \deqn{\lambda_0(t) = \exp{\theta_0}.}

  Simulation is conditional on known time-independent effects, and the
  methodology of Bender et al. (2005) is used to simulate the failure time.}

  \item{\code{model="intslope"}}{The baseline hazard function is specified to
  be a Gompertz distribution with

  \deqn{\lambda_0(t) = \exp{\theta_0 + \theta_1 t}.}

  In the usual representation of the Gompertz distribution, \eqn{\theta_1} is
  the shape parameter, and the scale parameter is equivalent to
  \eqn{\exp(\theta_0)}. Simulation is conditional on on a predictable
  (linear) time-varying process, and the methodology of Austin (2012) is used
  to simulate the failure time.}

  }
}
\examples{
beta <- rbind(c(0.5, 2, 1, 1),
c(2, 2, -0.5, -1))
D <- diag(4)
D[1, 1] <- D[3, 3] <- 0.5
D[1, 2] <- D[2, 1] <- D[3, 4] <- D[4, 3] <- 0.1
D[1, 3] <- D[3, 1] <- 0.01

sim <- simData(n = 250, beta = beta, D = D, sigma2 = c(0.25, 0.25),
               censlam = exp(-0.2), gamma.y = c(-.2, 1), ntms = 8)
}
\references{
Austin PC. Generating survival times to simulate Cox proportional hazards
models with time-varying covariates. \emph{Stat Med.} 2012; \strong{31(29)}:
3946-3958.

Bender R, Augustin T, Blettner M. Generating survival times to simulate Cox
proportional hazards models. \emph{Stat Med.} 2005; \strong{24}: 1713-1723.

Henderson R, Diggle PJ, Dobson A. Joint modelling of longitudinal
measurements and event time data. \emph{Biostatistics.} 2000; \strong{1(4)}:
465-480.
}
\author{
Pete Philipson (\email{pete.philipson@northumbria.ac.uk}) and Graeme
  L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{datagen}
\keyword{multivariate}
\keyword{survival}
