% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bib2dt.R
\name{read_bib2dt}
\alias{read_bib2dt}
\title{Parse a BibTeX file to a \code{data.table}.}
\usage{
read_bib2dt(file)
}
\arguments{
\item{file}{character, path or URL to a bib file.}
}
\value{
A \code{data.table}.
}
\description{
The BibTeX file is read, parsed, tidied and written to a \code{data.table}.
}
\details{
Read, parse and collate bibtex file to form a data.table.
  Different BIB may produce different data.table columns.
}
\examples{
# Read from .bib file:
file1 <- system.file("extdata", "testfile_1.bib", package = "journalabbr", mustWork = TRUE)
dt1 <- read_bib2dt(file1)
colnames(dt1)

file2 <- system.file("extdata", "testfile_2.bib", package = "journalabbr", mustWork = TRUE)
dt2 <- read_bib2dt(file2)
colnames(dt2)

}
\author{
ShuCai Zou
}
