% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{types}
\alias{types}
\alias{type}
\alias{type_}
\title{Types and related functions}
\usage{
types(.data)

type(.data, ...)

type_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Types and related functions
}
\examples{
# get type information for each element
jq('[0, false, [], {}, null, "hello"]', 'map(type)')
'[0, false, [], {}, null, "hello"]' \%>\% types
'[0, false, [], {}, null, "hello", true, [1,2,3]]' \%>\% types

# select elements by type
jq('[0, false, [], {}, null, "hello"]', '.[] | numbers,booleans')
'[0, false, [], {}, null, "hello"]' \%>\% index() \%>\% type(booleans)
}
