% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{npv}
\alias{npv}
\title{Net Present Value}
\usage{
npv(
  cf,
  rate,
  cf.freq = 1,
  comp.freq = 1,
  cf.t = seq(from = if (immediate.start) 0 else 1/cf.freq, by = 1/cf.freq, along.with =
    cf),
  immediate.start = FALSE
)
}
\arguments{
\item{cf}{Vector of cash flows}

\item{rate}{The interest rate in decimal (0.10 or 10e-2 for 10\%)}

\item{cf.freq}{Frequency of annuity payments: 1 for annual, 2 for
semi-annual, 12 for monthly.}

\item{comp.freq}{Frequency of compounding of interest rates: 1 for annual,
2 for semi-annual, 12 for monthly, Inf for continuous compounding.}

\item{cf.t}{Optional vector of timing (in years) of cash flows. If omitted
regular sequence of years is assumed.}

\item{immediate.start}{Logical variable which is \code{TRUE} when the first cash
flows is at the beginning of the first period (for example, immediate
annuities) and \code{FALSE} when the first cash flows is at the end of the first
period (for example, deferred annuities)}
}
\description{
Computes NPV (Net Present Value) for cash flows with different cash flow and
compounding conventions. Cash flows need not be evenly spaced.
}
