% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regressModule2}
\alias{regressModule2}
\title{regressModule2: Shiny modulde server for linear regression for reactive data.}
\usage{
regressModule2(input, output, session, data, data_label,
  data_varStruct = NULL, nfactor.limit = 10, design.survey = NULL,
  default.unires = T, limit.unires = 20)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{reactive data}

\item{data_label}{reactive data label}

\item{data_varStruct}{List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{reactive survey data. default: NULL}

\item{default.unires}{Set default independent variables using univariate analysis, Default: T}

\item{limit.unires}{Change to default.unires = F if number of independent variables > limit.unires, Default: 20}
}
\value{
Shiny modulde server for linear regression.
}
\description{
Shiny modulde server for linear regression for reactive data.
}
\details{
Shiny modulde server for linear regression.
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     regressModuleUI("linear")
   ),
   mainPanel(
     DTOutput("lineartable")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_linear <- callModule(regressModule2, "linear", data = data, data_label = data.label,
                           data_varStruct = NULL)

  output$lineartable <- renderDT({
    datatable(out_linear()$table, rownames=T, caption = out_linear()$caption)
  })
}
}
