% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeroc.R
\name{survIDINRI_helper}
\alias{survIDINRI_helper}
\title{survIDINRI_helper: Helper function for IDI.INF.OUT in survIDINRI packages}
\usage{
survIDINRI_helper(var.event, var.time, list.vars.ind, t, data,
  dec.auc = 3, dec.p = 3, id.cluster = NULL)
}
\arguments{
\item{var.event}{event}

\item{var.time}{time}

\item{list.vars.ind}{list of independent variable}

\item{t}{time}

\item{data}{data}

\item{dec.auc}{digits for AUC, Default: 3}

\item{dec.p}{digits for p value, Default: 3}

\item{id.cluster}{cluster variable if marginal model, Default: NULL}
}
\value{
IDI, NRI
}
\description{
Helper function for IDI.INF.OUT in survIDINRI packages
}
\details{
Helper function for IDI.INF.OUT in survIDINRI packages
}
\examples{
#library(survival)
#survIDINRI_helper("status", "time", list.vars.ind = list("age", c("age", "sex")),
#                  t = 365, data = lung)
}
\seealso{
\code{\link[data.table]{data.table-package}}
 \code{\link[stats]{model.matrix}}
 \code{\link[survival]{coxph}}
 \code{\link[survival]{Surv}}
 \code{\link[survIDINRI]{IDI.INF.OUT}}
 \code{\link[survIDINRI]{IDI.INF}}
}
