% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{coxModule}
\alias{coxModule}
\title{coxModule: shiny modulde server for Cox's model.}
\usage{
coxModule(
  input,
  output,
  session,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 10,
  design.survey = NULL,
  default.unires = T,
  limit.unires = 20,
  id.cluster = NULL
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{reactive data}

\item{data_label}{reactuve data label}

\item{data_varStruct}{reactive list of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{reactive survey data. default: NULL}

\item{default.unires}{Set default independent variables using univariate analysis.}

\item{limit.unires}{Change to default.unires = F if number of independent variables > limit.unires, Default: 20}

\item{id.cluster}{reactive cluster variable if marginal cox model, Default: NULL}
}
\value{
Shiny modulde server for Cox's model.
}
\description{
Shiny modulde server for Cox's model.
}
\details{
Shiny modulde server for Cox's model.
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     coxUI("cox")
   ),
   mainPanel(
     DTOutput("coxtable")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_cox <- callModule(coxModule, "cox", data = data, data_label = data.label,
                           data_varStruct = NULL)

  output$coxtable <- renderDT({
    datatable(out_cox()$table, rownames=T, caption = out_cox()$caption)
  })
}
}
