% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{reclassificationJS}
\alias{reclassificationJS}
\title{reclassificationJS: Function for reclassification table and statistics}
\usage{
reclassificationJS(
  data,
  cOutcome,
  predrisk1,
  predrisk2,
  cutoff,
  dec.value = 3,
  dec.p = 3
)
}
\arguments{
\item{data}{Data frame or matrix that includes the outcome and predictors variables.}

\item{cOutcome}{Column number of the outcome variable.}

\item{predrisk1}{Vector of predicted risks of all individuals using initial model.}

\item{predrisk2}{Vector of predicted risks of all individuals using updated model.}

\item{cutoff}{Cutoff values for risk categories. Define the cut-off values. Ex: c(0,.20,.30,1)}

\item{dec.value}{digits of value, Default: 4}

\item{dec.p}{digits of p, Default: 3}
}
\value{
Table including NRI(categorical), NRI(continuous), IDI with 95% CI and p-values.
}
\description{
Modified function of PredictABEL::reclassification: return output table
}
\details{
Modified function of PredictABEL::reclassification
}
\examples{
 m1 <- glm(vs ~ am + gear, data = mtcars, family = binomial)
 m2 <- glm(vs ~ am + gear + wt, data = mtcars, family = binomial)
 reclassificationJS(data = mtcars, cOutcome = 8,
                    predrisk1 = predict(m1, type = "response"),
                    predrisk2=predict(m2, type = "response"), cutoff = c(0,.20,.40,1))
}
\seealso{
\code{\link[Hmisc]{rcorrp.cens}}
}
