% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten}
\alias{flatten}
\title{Flatten nested data frames}
\usage{
flatten(x, recursive = TRUE)
}
\arguments{
\item{x}{a data frame}

\item{recursive}{flatten recursively}
}
\description{
In a nested data frame, one or more of the columns consist of another data
frame. These structures frequently appear when parsing JSON data from the web.
We can flatten such data frames into a regular 2 dimensional tabular structure.
}
\examples{
options(stringsAsFactors=FALSE)
x <- data.frame(driver = c("Bowser", "Peach"), occupation = c("Koopa", "Princess"))
x$vehicle <- data.frame(model = c("Piranha Prowler", "Royal Racer"))
x$vehicle$stats <- data.frame(speed = c(55, 34), weight = c(67, 24), drift = c(35, 32))
str(x)
str(flatten(x))
str(flatten(x, recursive = FALSE))

\dontrun{
data1 <- fromJSON("https://api.github.com/users/hadley/repos")
colnames(data1)
colnames(data1$owner)
colnames(flatten(data1))

# or for short:
data2 <- fromJSON("https://api.github.com/users/hadley/repos", flatten = TRUE)
colnames(data2)
}
}

