% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{json_delete}
\alias{json_delete}
\title{Remove JSON element}
\usage{
json_delete(x, ...)
}
\arguments{
\item{x}{A JSON vector.}

\item{...}{Paths to delete.}
}
\value{
A \code{json2} vector similar to \code{x} with the specified paths removed
from it.
}
\description{
Remote the elements at the specified paths from a JSON vector.
}
\examples{
x <- c('{"a": 11, "b": {"x": 12}}', NA)

json_delete(x, "$.a")
# remove from multiple paths at once
json_delete(x, "$.a", "$.b")
# remove at a nested path
json_delete(x, "$.b.x")

# non-existing elements are just ignored
json_delete(x, "$.abc")
}
