% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{find_authors}
\alias{find_authors}
\title{Extract author information}
\usage{
find_authors(file_path)
}
\arguments{
\item{file_path}{A \code{.xml}-file from JSTOR containing meta-data.}
}
\value{
A \code{tibble} containing the extracted authors. All empty fields are
\code{NA_character}.
}
\description{
\code{find_authors()} extracts information about authors from JSTOR-XML files.
}
\details{
The function returns a \code{tibble} with the following six columns:
\itemize{
\item \emph{prefix}: in case there was a prefix to the name, like \code{"Dr."}.
\item \emph{given_name}: The author's given name, like \code{"Albert"}.
\item \emph{surname}: The author's surname like \code{"Einstein"}.
\item \emph{string_name}: In some cases data the name is not available in separate
fields, but just as a complete string: \code{"Albert Einstein"}.
\item \emph{suffix}: a suffix to the name, like \code{"Jr."}.
\item \emph{author_number}: The authors are enumerated in the order they appear in the
data.
}
}
\examples{
find_authors(jstor_example("sample_with_references.xml"))
}
