% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jtdm_fit.R
\name{jtdm_fit}
\alias{jtdm_fit}
\title{Fitting joint trait distribution models}
\usage{
jtdm_fit(Y, X, formula, sample = 1000)
}
\arguments{
\item{Y}{The sites x traits matrix containing community (weighted) means of each trait at each site.}

\item{X}{The design matrix, i.e. sites x predictor matrix containing the value of each explanatory variable (e.g. the environmental conditions) at each site.}

\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under 'Details'.}

\item{sample}{Number of samples from the posterior distribution. Since we sample from the exact posterior distribution, the number of samples is relative lower than MCMC samplers. As a rule of thumb, 1000 samples should provide correct inference.}
}
\value{
A list containing:
   \item{model}{ An object of class "jtdm_fit", containing the samples from the posterior distribution of the regression coefficients (B) and residual covariance matrix (Sigma), together with the likelihood of the model.}
   \item{Y}{A numeric vector of standard errors on parameters}
   
   \item{X_raw}{The design matrix specified as input}
   
   \item{X}{The design matrix transformed as specified in formula}
   
   \item{formula}{The formula specified as input}
}
\description{
jtdm_fit is used to fit a Joint trait distribution model. Requires the response variable Y (the sites x traits matrix) and the explanatory variables X.This function samples from the posterior distribution of the parameters, which has been analytically determined. Therefore, there is no need for classical MCMC convergence checks.
}
\details{
A formula has an implied intercept term. To remove this use either y ~ x - 1 or y ~ 0 + x. See formula for more details of allowed formulae.
}
\examples{
data(Y)  
data(X)  
m = jtdm_fit(Y = Y, X = X, formula = as.formula("~GDD+FDD+forest"), sample = 1000)  
}
