#' Asia
#'
#' Small synthetic data set from Lauritzen and Spiegelhalter (1988) about lung
#' diseases (tuberculosis, lung cancer or bronchitis) and visits to Asia. This
#' copy of the data was taken from the R package "bnlearn" where all values
#' "yes" have been converted to "y" and all values "no" have been converted
#' to "n".
#'
#' \describe{
#'   \item{\code{D} (dysponea)}{}
#'   \item{\code{T} (tuberculosis)}{}
#'   \item{\code{L} (lung cancer)}{}
#'   \item{\code{B} (bronchitis)}{}
#'   \item{\code{A} (visit to Asia)}{}
#'   \item{\code{S} (smoking)}{}
#'   \item{\code{X} (chest C-ray)}{}
#'   \item{\code{E} (tuberculosis vs cancer/bronchitis)}{}
#' }
#' 
#' @docType data
#' 
#' @references \href{https://www.bnlearn.com/documentation/man/asia.html}{bnlearn-asia}
"asia"


#' Asia2
#'
#' See the \code{asia} data for information. This version, has class \code{bn.fit}.
#'
#' @docType data
#' 
#' @references \href{https://www.bnlearn.com/bnrepository/discrete-small.html#asia}{bnlearn-asia}
"asia2"
