% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_predictions.R
\name{make_predictions.stanreg}
\alias{make_predictions.stanreg}
\title{Make predictions for stanreg models}
\usage{
\method{make_predictions}{stanreg}(model, pred, pred.values = NULL,
  modx = NULL, modx.values = NULL, mod2 = NULL, mod2.values = NULL,
  centered = "all", data = NULL, plot.points = FALSE,
  interval = TRUE, int.width = 0.95, estimate = "mean",
  linearity.check = FALSE, set.offset = 1, pred.labels = NULL,
  modx.labels = NULL, mod2.labels = NULL, preds.per.level = 100,
  force.cat = FALSE, facet.modx = linearity.check, ...)
}
\arguments{
\item{model}{A \code{stanreg} model.}

\item{pred}{The name of the predictor variable involved
in the interaction. This must be a string.}

\item{pred.values}{Which values of the predictor should be included in the
plot? By default, all levels are included.}

\item{modx}{The name of the moderator variable involved
in the interaction. This must be a string.}

\item{modx.values}{For which values of the moderator should lines be plotted?
Default is \code{NULL}. If \code{NULL}, then the customary +/- 1 standard
deviation from the mean as well as the mean itself are used for continuous
moderators. If \code{"plus-minus"}, plots lines when the moderator is at
+/- 1 standard deviation without the mean. You may also choose \code{"terciles"}
to split the data into equally-sized groups and choose the point at the
mean of each of those groups.

If the moderator is a factor variable and \code{modx.values} is
\code{NULL}, each level of the factor is included. You may specify
any subset of the factor levels (e.g., \code{c("Level 1", "Level 3")}) as long
as there is more than 1. The levels will be plotted in the order you
provide them, so this can be used to reorder levels as well.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction. This can be a bare name or string.}

\item{mod2.values}{For which values of the second moderator should the plot
be
facetted by? That is, there will be a separate plot for each level of this
moderator. Defaults are the same as \code{modx.values}.}

\item{centered}{A vector of quoted variable names that are to be
mean-centered. If \code{"all"}, all non-focal predictors are centered. You
may instead pass a character vector of variables to center. User can
also use "none" to base all predictions on variables set at 0.
The response variable, \code{pred}, \code{modx}, and \code{mod2} variables are never
centered.}

\item{data}{Optional, default is NULL. You may provide the data used to
fit the model. This can be a better way to get mean values for centering
and can be crucial for models with variable transformations in the formula
(e.g., \code{log(x)}) or polynomial terms (e.g., \code{poly(x, 2)}). You will
see a warning if the function detects problems that would likely be
solved by providing the data with this argument and the function will
attempt to retrieve the original data from the global environment.}

\item{plot.points}{Logical. If \code{TRUE}, plots the actual data points as
a scatterplot on top of the interaction lines. The color of the dots will
be based on their moderator value.}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction
intervals around the line using \code{\link[ggplot2]{geom_ribbon}}.}

\item{int.width}{How large should the interval be, relative to the standard
error? The default, .95, corresponds to roughly 1.96 standard errors and
a .05 alpha level for values outside the range. In other words, for a
confidence interval, .95 is analogous to a 95\% confidence interval.}

\item{estimate}{Should estimates be based on mean or median simulation?
Default is "mean".}

\item{linearity.check}{For two-way interactions only. If \code{TRUE}, plots a
pane for each level of the moderator and superimposes a loess smoothed
line (in gray) over the plot. This enables you to see if the effect is
linear through the span of the moderator. See Hainmueller et al. (2016) in
the references for more details on the intuition behind this. It is
recommended that you also set \code{plot.points = TRUE} and use
\code{modx.values = "terciles"} with this option.}

\item{set.offset}{For models with an offset (e.g., Poisson models), sets an
offset for the predicted values. All predicted values will have the same
offset. By default, this is set to 1, which makes the predicted values a
proportion. See details for more about offset support.}

\item{pred.labels}{A character vector of 2 labels for the predictor if it is
a 2-level factor or a continuous variable with only 2 values. If
\code{NULL}, the default, the factor labels are used.}

\item{modx.labels}{A character vector of labels for each level of the
moderator values, provided in the same order as the \code{modx.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{modx,values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{mod2.labels}{A character vector of labels for each level of the 2nd
moderator values, provided in the same order as the \code{mod2.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{mod2.values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{preds.per.level}{For continuous predictors, a series of equally
spaced points across the observed range of the predictor are used to
create the lines for each level of the moderator. Use this to choose
how many points are used for that. Default is 100, but for complicated
models larger numbers may better capture the curvature.}

\item{force.cat}{If \code{TRUE}, treats numeric predictor as categorical. This
can be helpful when you have 0/1 dummy variables that you don't want to
plot as if intermediate values are possible.}

\item{facet.modx}{Create separate panels for each level of the moderator?
Default is FALSE, except when \code{linearity.check} is TRUE.}

\item{...}{Ignored.}
}
\description{
This method adds support for \code{plot_predictions},
\code{interact_plot}, \code{cat_plot}, and \code{effect_plot} for models fit with
\code{rstanarm}.
}
