% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svytools.R
\name{svysd}
\alias{svysd}
\title{Calculate standard deviations with complex survey data}
\usage{
svysd(formula, design, na.rm = FALSE,
  digits = getOption("jtools-digits", default = 3), ...)
}
\arguments{
\item{formula}{A formula (e.g., ~var1+var2) specifying the term(s) of interest.}

\item{design}{The \code{survey.design} or \code{svyrep.design} object.}

\item{na.rm}{Logical. Should cases with missing values be dropped?}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 3. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired number.}

\item{...}{Additional arguments passed to \code{\link[survey]{svyvar}}.}
}
\description{
\code{svysd} extends the \code{survey} package by calculating standard
deviations with syntax similar to the original package, which provides
only a \code{\link[survey]{svyvar}} function.
}
\details{
An alternative is to simply do \code{sqrt(svyvar(~term, design = design))}.
However, if printing and sharing the output, this may be misleading since
the output will say "variance."
}
\note{
This function was designed independent of the \pkg{survey} package and
is neither endorsed nor known to its authors.
}
\examples{
if (requireNamespace("survey")) {
 library(survey)
 data(api)
 # Create survey design object
 dstrat <- svydesign(id = ~1,strata = ~stype, weights = ~pw, data = apistrat,
                     fpc=~fpc)

 # Print the standard deviation of some variables
 svysd(~api00+ell+meals, design = dstrat)
}

}
\seealso{
\code{\link[survey]{svyvar}}

Other \pkg{survey} package extensions: \code{\link{svycor}}

Other survey tools: \code{\link{pf_sv_test}},
  \code{\link{svycor}}, \code{\link{weights_tests}},
  \code{\link{wgttest}}
}
\concept{\pkg{survey} package extensions}
\concept{survey tools}
