\name{fit.sb}
\alias{fit.sb}
\alias{fit.sl}
\alias{fit.su}
\alias{qtls}
\title{Fit Functions for Johnson Curves}
\usage{
  fit.sb(x, q)

  fit.sl(x, q)

  fit.su(x, q)

  qtls(x, z)
}
\arguments{
  \item{x}{the non-normal numerical data.}

  \item{q}{the quantiles and some statistics generated by
  quantiles, it must be the return value of \code{qtls}
  function.}

  \item{z}{current z value, Mandraccia, Halverson and Chou
  (1996) suggest using 101 z values from 0.25 to 1.25.}
}
\value{
  return NA when fit failed, return a list with 2 component
  when fit succeeded. The first component \code{trans} is
  the transformed value and the second component
  \code{params} is the parameters used in the
  transformation.
}
\description{
  Fit functions for three Johnson Curves.
}
\details{
  Three types of transformations are SB, SL and SU. Their
  forms are described below: \deqn{S_B: Z = \gamma + \eta *
  ln((X-\epsilon) / (\lambda + \epsilon - X))} \deqn{S_L: Z
  = \gamma + \eta * ln(X - \epsilon)} \deqn{S_U: Z = \gamma
  + \eta * asinh((X-\epsilon) / \lambda)} in whihc Z is the
  standard normal varible, and X is the non-normal original
  data, all the necessary parameters will be returned.
  Before fitting these curves, sample quantiles should be
  calculated according to z values. the \code{qtls}
  function here is to provide every useful parameters for
  Johnson curve fitting.
}

