% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.r
\name{expandFactors}
\alias{expandFactors}
\title{Takes factors from a data frame and converts them to true/false fields
  with appropriately named fields.}
\usage{
expandFactors(x, consider = names(x), sep = "", na.rm = TRUE,
  verbose = FALSE)
}
\arguments{
\item{x}{data.frame to search for factors to convert}

\item{consider}{character vector of field names in the data frame to
consider. Defaults to all fields}

\item{sep}{character scalar used to separate field prefixes from factor
values in new column names}

\item{na.rm}{logical scalar: if NA data and/or NA levels, then covert to NA
strings and expand these as for any other factor}

\item{verbose}{single logical value, if \code{TRUE} then produce verbose
messages}
}
\value{
data.frame with no factors
}
\description{
For a two level factor, this is relatively easy, since we just
  replace the field with \code{x==levels(x)[1]} or something like that, and
  rename the field to indicate that TRUE is level 1 of the factor. This works
  well for gender. For multi-level factors there is redundancy with multiple
  new fields now containing FALSE, with only one TRUE for the matching level.
}
\seealso{
\code{PSAgraphics::cv.trans.psa}
}

