% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aws.R
\name{aws_info}
\alias{aws_info}
\alias{aws_ls}
\alias{aws_bucket}
\title{List all objects in an AWS bucket}
\usage{
aws_info(bucket = aws_bucket(), prefix = NULL, max = Inf, ...)

aws_ls(bucket = aws_bucket(), prefix = NULL, ...)

aws_bucket(bucket = getOption("aws.bucket"), set = FALSE)
}
\arguments{
\item{bucket}{Character string with the name of the bucket. If you use the
same bucket frequently, you can set a default through an option named
that can be retrieved with \code{\link[=aws_bucket]{aws_bucket()}}.}

\item{prefix}{Character string that limits the response to keys that begin
with the specified prefix.}

\item{max}{Number of objects to return.}

\item{...}{Additional arguments passed to \code{\link[aws.s3:s3HTTP]{aws.s3::s3HTTP()}}.}

\item{set}{If \code{TRUE}, print instructions for setting the option.}
}
\value{
A list of objects on the AWS bucket.
}
\description{
\code{\link[=aws_info]{aws_info()}} uses \code{\link[aws.s3:get_bucket]{aws.s3::get_bucket_df()}} to return a tibble of stored
objects in a remote bucket, like \code{\link[fs:dir_ls]{fs::dir_info()}} returns information on a
local directory.

\code{\link[=aws_ls]{aws_ls()}} also uses \code{\link[aws.s3:get_bucket]{aws.s3::get_bucket_df()}} but only returns the filenames
within the bucket as a named \code{fs_path} character vector, like
\code{\link[fs:dir_ls]{fs::dir_ls()}}) returns files in a local directory.
}
\examples{
aws_info("1000genomes", max = 10)
aws_ls("irs-form-990", max = 1)
}
