% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_multinormal.R
\name{convert_multi_NG_Normal}
\alias{convert_multi_NG_Normal}
\title{convert_multi_NG_Normal}
\usage{
convert_multi_NG_Normal(ft, Qt, parms)
}
\arguments{
\item{ft}{numeric: A vector representing the means from the normal distribution.}

\item{Qt}{matrix: A matrix representing the covariance matrix of the normal distribution.}

\item{parms}{list: A list of extra known parameters of the distribution. Not used in this kernel.}
}
\value{
The parameters of the conjugated distribution of the linear predictor.
}
\description{
Calculate the parameters of the Normal-Gamma that best approximates the given Multivariate Normal distribution. The distribution obtained for each outcome is marginal.
The approximation is the best in the sense that it minimizes the KL divergence from the Normal to the Normal-Gamma.
In this approach, we suppose that the first entry of the multivariate normal represents the mean of the observed data and the second represent the log variance.
}
\seealso{
Other auxiliary functions for a Normal outcome: 
\code{\link{multi_normal_gamma_pred}()},
\code{\link{normal_pred}()},
\code{\link{update_Normal}()}
}
\concept{auxiliary functions for a Normal outcome}
\keyword{internal}
