% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_footnote.R
\name{add_footnote}
\alias{add_footnote}
\title{Add footnote}
\usage{
add_footnote(input, label = NULL, notation = "alphabet",
  threeparttable = FALSE)
}
\arguments{
\item{input}{The direct output of your \code{kable} function or your last
\code{kableExtra} function.}

\item{label}{A vector of footnotes you want to add. You don't need to add
notations in your notes.}

\item{notation}{You can select the format of your footnote notation from
\code{number}, \code{alphabet} and \code{symbol}.}

\item{threeparttable}{Boolean value indicating if a
\href{https://www.ctan.org/pkg/threeparttable}{threeparttable} scheme should
be used.}
}
\description{
Add footnote to your favorite kable output. So far this function
only works when you define \code{format} in your kable function or in the
global knitr option \code{knitr.table.format}. In latex, we are using the
\code{threeparttable} package so you need to import this package in your
\code{YAML} header.
}
\examples{
x <- knitr::kable(head(mtcars), "html")
add_footnote(x, c("footnote 1", "footnote 2"), notation = "symbol")

}
