% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/subset.R
\docType{class}
\name{RefineCA-class}
\alias{RefineCA-class}
\alias{.RefineCA}
\alias{[[,RefineCA,ANY,missing-method}
\title{Partial Bootstrap CA}
\usage{
\S4method{[[}{RefineCA,ANY,missing}(x, i)
}
\arguments{
\item{x}{An object from which to extract element(s) or in which to replace
element(s).}

\item{i}{A \code{\link{character}} string specifying elements to extract.}
}
\description{
An S4 class to store partial bootstrap correspondence analysis results.
}
\section{Functions}{
\itemize{
\item \code{[[,RefineCA,ANY,missing-method}: Extracts information from a slot selected
by subscript i. i is a length-one character vector. Returns the
corresponding slot values.
}}

\section{Slots}{

\describe{
\item{\code{hull}}{A three columns \code{\link{numeric}} matrix giving the vertices
coordinates (\code{x}, \code{y}) of the convex hull and a identifier (\code{id})
to link each row to a variable.}

\item{\code{length}}{A \code{\link{numeric}} vector giving the convex hull maximum
dimension length.}

\item{\code{keep}}{An \code{\link{integer}} vector giving the subscript of the variables
to be kept.}

\item{\code{cutoff}}{A length-one \code{\link{numeric}} vector giving the cutoff value for
samples selection.}
}}

\seealso{
\code{\link[dimensio:CA-class]{dimensio::CA}}

Other classes: 
\code{\link{AoristicSum-class}},
\code{\link{CountApportion-class}},
\code{\link{EventDate-class}},
\code{\link{IncrementTest-class}},
\code{\link{MeanDate-class}},
\code{\link{PermutationOrder-class}},
\code{\link{RateOfChange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
