% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_date.R
\docType{methods}
\name{predict_event}
\alias{predict_event}
\alias{predict_event-method}
\alias{predict_accumulation}
\alias{predict_accumulation-method}
\alias{predict_event,EventDate,missing-method}
\alias{predict_event,EventDate,matrix-method}
\alias{predict_accumulation,EventDate,missing-method}
\alias{predict_accumulation,EventDate,matrix-method}
\title{Predict Event and Accumulation Dates}
\usage{
predict_event(object, data, ...)

predict_accumulation(object, data, ...)

\S4method{predict_event}{EventDate,missing}(object, margin = 1, level = 0.95, calendar = NULL)

\S4method{predict_event}{EventDate,matrix}(object, data, margin = 1, level = 0.95, calendar = NULL)

\S4method{predict_accumulation}{EventDate,missing}(object)

\S4method{predict_accumulation}{EventDate,matrix}(object, data)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{data}{A \code{numeric} \code{\link{matrix}} or a \code{\link{data.frame}} of count data
(absolute frequencies) for which to predict event and accumulation dates.}

\item{...}{Further arguments to be passed to internal methods.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the prediction
will be applied over: \code{1} indicates rows, \code{2} indicates columns.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}). If \code{NULL} (the default), \emph{rata die} are returned.}
}
\value{
\itemize{
\item \code{predict_event()} returns a \code{\link{data.frame}}.
\item \code{predict_accumulation()} returns a \code{\link{data.frame}}.
}
}
\description{
Estimates the event and accumulation dates of an assemblage.
}
\note{
Bellanger \emph{et al.} did not publish the data supporting their demonstration:
no replication of their results is possible. This implementation must be
considered \strong{experimental} and subject to major changes in a future
release.
}
\examples{
\dontrun{
utils::vignette("event")
}
}
\references{
Bellanger, L. & Husi, P. (2013). Mesurer et modéliser le temps inscrit dans
la matière à partir d'une source matérielle : la céramique médiévale.
In \emph{Mesure et Histoire Médiévale}. Histoire ancienne et médiévale.
Paris: Publication de la Sorbonne, p. 119-134.

Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
Archaeological Science}, 39(4), 777-790. \doi{10.1016/j.jas.2011.06.031}.

Bellanger, L., Tomassone, R. & Husi, P. (2008). A Statistical Approach for
Dating Archaeological Contexts. \emph{Journal of Data Science}, 6, 135-154.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Une approche statistique
pour la datation de contextes archéologiques. \emph{Revue de Statistique
Appliquée}, 54(2), 65-81.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Statistical Aspects of
Pottery Quantification for the Dating of Some Archaeological Contexts.
\emph{Archaeometry}, 48(1), 169-183. \doi{10.1111/j.1475-4754.2006.00249.x}.
}
\seealso{
\code{\link[=event]{event()}}

Other dating methods: 
\code{\link{event}()},
\code{\link{mcd}()}
}
\author{
N. Frerebeau
}
\concept{dating methods}
