% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.r
\docType{methods}
\name{make_psd,matrix-method}
\alias{make_psd,matrix-method}
\alias{make_psd}
\alias{matrix}
\title{Adjust network \code{matrix} to be positive semi-definite}
\usage{
\S4method{make_psd}{matrix}(x, eps = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{A \code{matrix} specifying the network adjacency matrix.}

\item{eps}{A \code{numeric} value, setting the tolance for smallest 
eigenvalue adjustment}
}
\value{
The \code{matrix} \code{x}, if it is positive definite and the closest
positive semi-definite \code{matrix} if \code{x} is not positive semi-definite.
}
\description{
Adjust network \code{matrix} to be positive semi-definite
}
\details{
For a \code{matrix} N, the closest positive semi-definite \code{matrix} is 
calculated as N* = rho*N + (1+rho)*I, where I is the identity \code{matrix}
and rho = 1/(1 - lambda) with lambda the smallest eigenvalue of N. 
For more details check the references.
}
\references{
\itemize{
 \item Freytag S, Manitz J, Schlather M, Kneib T, Amos CI, Risch A, Chang-Claude J, Heinrich J, Bickeboeller H: A network-based kernel machine test for the identification of risk pathways in genome-wide association studies. Hum Hered. 2013, 76(2):64-75.
}
}
\author{
Juliane Manitz, Saskia Freytag, Stefanie Friedrichs
}
