% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASdata.r
\docType{methods}
\name{GWASdata}
\alias{GWASdata}
\alias{GWASdata,ANY-method}
\alias{show,GWASdata-method}
\alias{summary,GWASdata-method}
\alias{GeneSNPsize,GWASdata-method}
\alias{GeneSNPsize}
\alias{GWASdata}
\title{S4 class for an object representing a Genome-wide Assocaition Study.}
\usage{
GWASdata(object, ...)

\S4method{GWASdata}{ANY}(geno, anno, pheno = NULL, desc = "")

\S4method{show}{GWASdata}(object)

\S4method{summary}{GWASdata}(object)

\S4method{GeneSNPsize}{GWASdata}(object)
}
\arguments{
\item{object}{A \code{\link{GWASdata}} object.}

\item{...}{Further arguments can be added to the function.}

\item{geno}{An object of any type, including the genotype information.}

\item{anno}{A \code{data.frame} containing the annotation file for the 
\code{GWASdata} object.}

\item{pheno}{A \code{data.frame} specifying individual IDs, phenotypes and
covariates to be included in the regression model.}

\item{desc}{A \code{character} giving the GWAS description, e.g. name of study.}
}
\description{
S4 class for an object representing a Genome-wide Assocaition Study.

\code{'GWASdata'} is a GWASdata object constructor.

\code{show} displays basic information on \code{\link{GWASdata}} object

\code{summary} summarizes the content of a \code{\link{GWASdata}} object 
and gives an overview about the information included in a 
\code{\link{GWASdata}} object. Summary statistics for phenotype and genotype 
data are calculated.

\code{GeneSNPsize} creates a \code{data.frame} of \code{\link{pathway}}
names with numbers of snps and genes in each \code{\link{pathway}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{GeneSNPsize}: creates a \code{data.frame} of \code{\link{pathway}} names with numbers 
of snps and genes in each pathway.
}}

\section{Slots}{

\describe{
\item{\code{geno}}{An object of any type, including genotype information. The format
needs to be one line per individual and on colum per SNP in minor-allele 
coding (0,1,2). Other values between 0 and 2, as from impute dosages, are 
allowed. Missing values must be imputed prior to creation of a \code{GWASdata} object.}

\item{\code{anno}}{A \code{data.frame} mapping SNPs to genes and genes to
pathways. Needs to include the columns 'pathway' (pathway ID, e.g. hsa
number from KEGG database), 'gene' (gene name (hgnc_symbol)), 'chr'
(chromosome), 'snp' (rsnumber) and 'position' (base pair position of SNP).}

\item{\code{pheno}}{A \code{data.frame} specifying individual IDs, phenotypes and
covariates to be included in the regression model e.g. ID, pheno, sex,
pack.years. Note: IDs have to be in the first column!}

\item{\code{desc}}{A \code{character} giving the GWAS description, e.g. name of study.}
}}

\examples{
data(pheno)
data(geno)
data(anno)
gwas <- new('GWASdata', pheno=pheno, geno=geno, anno=anno, desc="some study") 
# show method
data(gwas) 
gwas
# summary method
data(gwas) 
summary(gwas)

# SNPs and genes in pathway
data(gwas) 
GeneSNPsize(gwas)
}
\author{
Juliane Manitz, Stefanie Friedrichs
}
