% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.r
\docType{class}
\name{kernel-class}
\alias{kernel-class}
\alias{kernel}
\alias{show,kernel-method}
\alias{summary,kernel-method}
\alias{summary,kernel,ANY-method}
\alias{plot,kernel,missing-method}
\alias{plot,kernel,ANY-method}
\title{An S4 class representing a kernel matrix calculated for a pathway}
\usage{
\S4method{show}{kernel}(object)

\S4method{summary}{kernel}(object)

\S4method{plot}{kernel,missing}(x, y = NA, hclust = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{kernel}}

\item{x}{the \code{kernel} object to be plotted.}

\item{y}{missing (placeholder).}

\item{hclust}{\code{logical}, indicating whether a dendrogram should be added.}

\item{...}{further arguments to be passed to the function.}
}
\description{
An S4 class representing a kernel matrix calculated for a pathway

\code{show} displays the \code{kernel} object briefly

\code{summary} generates a \code{kernel} object summary including the number of 
individuals and genes for the \code{\link{pathway}}

\code{plot} creates an image plot of a \code{kernel} object
}
\section{Slots}{

\describe{
\item{\code{type}}{A \code{character} representing the kernel type: Use 
\code{'lin'} for linear kernel, \code{'sia'} for the size-adjusted 
or \code{'net'} for the network-based kernel.}

\item{\code{kernel}}{A kernel \code{matrix} of dimension equal to the number of individuals}

\item{\code{pathway}}{A \code{\link{pathway}} object}
}}

\examples{
data(gwas)
data(hsa04020)
net_kernel <- calc_kernel(gwas, hsa04020, knots=NULL, type='net', calculation='cpu')

show(net_kernel)
summary(net_kernel)
plot(net_kernel, hclust=TRUE)

}
\author{
Juliane Manitz
}
