% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.r
\docType{class}
\name{lowrank_kernel-class}
\alias{lowrank_kernel-class}
\alias{lowrank_kernel}
\title{An S4 class to represent a low-rank kernel for a SNPset at specified knots}
\description{
An S4 class to represent a low-rank kernel for a SNPset at specified knots
}
\details{
This kernel is used for predictions. If observations and knots are 
equal, better construct a full-rank kernel of class \code{\link{kernel}}.
}
\section{Slots}{

\describe{
\item{\code{type}}{character, kernel type: Use \code{'lin'} for the linear kernel,
\code{'sia'} for the size-adjusted or \code{'net'} for the network-based kernel.}

\item{\code{kernel}}{kernel \code{matrix} of dimension equal to individuals}

\item{\code{pathway}}{\code{\link{pathway}} object}
}}

\examples{
data(gwas)
data(hsa04020)
square <- calc_kernel(gwas, hsa04020, knots=gwas, type='lin', calculation='cpu')
dim(square@kernel)

gwas2 <- new('GWASdata', pheno=pheno[1:10,], geno=geno[1:10,], anno=anno, desc="study 2")
low_rank <- calc_kernel(gwas, hsa04020, knots = gwas2, type='net', calculation='cpu')
dim(low_rank@kernel)
}
\author{
Juliane Manitz
}
