% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd.R
\name{math_to_rd}
\alias{math_to_rd}
\title{Display math in R documentation}
\usage{
math_to_rd(tex, ascii = tex, displayMode = TRUE, ..., include_css = TRUE)
}
\arguments{
\item{tex}{input string with tex math expression.}

\item{ascii}{alternate text-only representation of the input math to show in
documentation rendered to plain text format.}

\item{displayMode}{render math in centered 2D layout, similar to \verb{$$} in tex.
Set to \code{FALSE} to render (non-centered) inline layout for use in text.
For pdf output, this corresponds to the \verb{\deqn{}} and \verb{\eqn{}} macros, see
\href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#Mathematics}{WRE 2.6: Mathematics}}

\item{...}{additional html rendering options passed to
\href{https://katex.org/docs/options.html}{katex.render}}

\item{include_css}{adds the katex css file to the output.
This is only required once per html webpage. Set to \code{FALSE} if you include css
files into the your html head some other way.}
}
\value{
a string with an rd fragment to be included in R documentation
}
\description{
Helper function to insert tex math expressions into R documentation (\code{.rd}) files.
Uses Katex rendering for documentation in html format, and the appropriate latex
macros for documentation rendered in pdf or plain-text.
}
\details{
Use \code{math_to_rd()} inside \verb{\\Sexpr} to embed math in your R package documentation
pages. For example the code below can be inserted in your \code{rd} (or roxygen)
source code:\preformatted{\\Sexpr[results=rd, stage=build]\{
  katex::math_to_rd(katex::example_math())
\}
}

Which results in the following output:

\Sexpr[results=rd, stage=build]{
katex::math_to_rd(katex::example_math())
}

Optionally you can specify an alternate ascii representation that will be shown in
the plain-text format rendering of the documentation:\preformatted{\\Sexpr[results=rd, stage=build]\{
  katex::math_to_rd('E=MC^2', 'E=mc²')
\}
}

\Sexpr[results=rd, stage=build]{
katex::math_to_rd('E=MC^2', 'E=MC²')
}

If no ascii representation is given, the input tex in displayed verbatim into the
plain-text documentation.
}
\section{Note for Windows}{
On Windows, R versions before 4.1.2 had a \href{https://bugs.r-project.org/show_bug.cgi?id=18152}{bug}
which could lead to incorrect HTML encoding for \verb{\\Sexpr\{\}} output.
As a workaround, we automatically escape non-ascii html characters
on these versions of R. Linux and MacOS are unaffected.
}

\seealso{
Other katex: 
\code{\link{katex}},
\code{\link{pandoc}}
}
\concept{katex}
