# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' fits a kernel density estimate and calculates the effective degrees of
#' freedom.
#' @param x vector of observations.
#' @param bw the bandwidth parameter.
#' @param xmin lower bound for the support of the density, `NaN` means no
#'   boundary.
#' @param xmax upper bound for the support of the density, `NaN` means no
#'   boundary.
#' @param deg order of the local polynomial.
#' @return `An Rcpp::List` containing the fitted density values on a grid and
#'   additional information.
#' @noRd
fit_kde1d_cpp <- function(x, bw, xmin, xmax, deg) {
    .Call('_kde1d_fit_kde1d_cpp', PACKAGE = 'kde1d', x, bw, xmin, xmax, deg)
}

#' computes the pdf of a kernel density estimate by interpolation.
#' @param x vector of evaluation points.
#' @param R_object the fitted object passed from R.
#' @return a vector of pdf values.
#' @noRd
dkde1d_cpp <- function(x, R_object) {
    .Call('_kde1d_dkde1d_cpp', PACKAGE = 'kde1d', x, R_object)
}

#' computes the cdf of a kernel density estimate by numerical integration.
#' @param x vector of evaluation points.
#' @param R_object the fitted object passed from R.
#' @return a vector of cdf values.
#' @noRd
pkde1d_cpp <- function(x, R_object) {
    .Call('_kde1d_pkde1d_cpp', PACKAGE = 'kde1d', x, R_object)
}

#' computes the quantile of a kernel density estimate by numerical inversion
#' (bisection method).
#' @param x vector of evaluation points.
#' @param R_object the fitted object passed from R.
#' @return a vector of quantiles.
#' @noRd
qkde1d_cpp <- function(x, R_object) {
    .Call('_kde1d_qkde1d_cpp', PACKAGE = 'kde1d', x, R_object)
}

#' @param x vector of observations
#' @param grid_size number of equally-spaced points over which binning is
#' performed to obtain kernel functional approximation
#' @return the selected bandwidth
#' @noRd
select_bw_cpp <- function(x, bw, mult, discrete) {
    .Call('_kde1d_select_bw_cpp', PACKAGE = 'kde1d', x, bw, mult, discrete)
}

