% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dprhkdecop.R
\name{hkdecop}
\alias{hkdecop}
\title{H-function and inverse of kdecopula object}
\usage{
hkdecop(u, obj, cond.var, inverse = FALSE)
}
\arguments{
\item{u}{\eqn{n x 2} matrix of evaluation points.}

\item{obj}{\code{kdecopula} object.}

\item{cond.var}{integer; \code{cond.var = 1} conditions on the first variable,
\code{cond.var = 2} on the secon.}

\item{inverse}{logical; indicates wether the h-function or its inverse shall be
calculated.}
}
\value{
A length \eqn{n} vector of the (inverse) h-function evaluated at
\code{u}.
}
\description{
Evaluates the h-function (or its inverse) corresponding to a \code{kdecopula}
object. H-functions are conditional distribution functions obtained by
integrating the copula density w.r.t. to one of its arguments (see also
\code{\link[VineCopula:BiCopHfunc]{BiCopHfunc}}).
}
\examples{
## load data and transform with empirical cdf
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x)/(length(x)+1))

## estimation of copula density of variables 5 and 6
dens.est <- kdecop(udat[, 5:6])
plot(dens.est) 

## evaluate h-function estimate and its inverse at (u1|u2) = (0.123 | 0.321)
hkdecop(c(0.123, 0.321), dens.est, cond.var = 2) 
hkdecop(c(0.123, 0.321), dens.est, cond.var = 2, inverse = TRUE) 

}
\author{
Thomas Nagler
}
\seealso{
\code{\link[kdecopula:kdecop]{kdecop}},
\code{\link[VineCopula:BiCopHfunc]{BiCopHfunc}}
}

